import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import { LanguageJsonResultModel, LgPageListSearchModel } from './model';

enum Api {
  Page = '/language/page',
  TypeList = '/language/type/list',
  TypePage = '/language/type/page',
  Json = '/language/main-language-json',
  AddLg = '/language',
  AddLgType = '/language/type',
}

/**
 * @description: 查询翻译管理分页列表
 */
export async function getLanguagePageList(
  params?: LgPageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询语言json
 */
export async function getLanguageJson(mode: ErrorMessageMode = 'modal') {
  return defHttp.get<LanguageJsonResultModel>(
    {
      url: Api.Json,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询语言类型列表
 */
export async function getLanguageTypeList(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.TypeList,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询语言类型分页列表
 */
export async function getLgTypePageList(
  params?: LgPageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get(
    {
      url: Api.TypePage,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除翻译管理（批量删除）
 */
export async function deleteLanguage(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.AddLg,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 删除语言类型（批量删除）
 */
export async function deleteLanguageType(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.AddLgType,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增翻译管理
 */
export async function addLanguage(auth: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<number>(
    {
      url: Api.AddLg,
      params: auth,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增语言类型
 */
export async function addLanguageType(auth: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<number>(
    {
      url: Api.AddLgType,
      params: auth,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新翻译管理
 */
export async function updateLanguage(auth: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<number>(
    {
      url: Api.AddLg,
      data: auth,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新语言类型
 */
export async function updateLanguageType(auth: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<number>(
    {
      url: Api.AddLgType,
      data: auth,
    },
    {
      errorMessageMode: mode,
    },
  );
}
