
import { MesProductionGongdanPageModel, MesProductionGongdanPageParams, MesProductionGongdanPageResult } from './model/GdglModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/scgl/gdgl/page',
  List = '/scgl/gdgl/list',
  Info = '/scgl/gdgl/info',
  MesProductionGongdan = '/scgl/gdgl',
  
  
  
}

/**
 * @description: 查询MesProductionGongdan分页列表
 */
export async function getMesProductionGongdanPage(params: MesProductionGongdanPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductionGongdanPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProductionGongdan信息
 */
export async function getMesProductionGongdan(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductionGongdanPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProductionGongdan
 */
export async function addMesProductionGongdan(mesProductionGongdan: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProductionGongdan,
      params: mesProductionGongdan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProductionGongdan
 */
export async function updateMesProductionGongdan(mesProductionGongdan: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProductionGongdan,
      params: mesProductionGongdan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProductionGongdan（批量删除）
 */
export async function deleteMesProductionGongdan(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProductionGongdan,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




