import {
  http
} from '@/common/request/index.js'; // 局部引入

const api = {
  OrganizationTree: '/organization/department/tree',
  OrganizationInfo: '/organization/department/info',
  UserPage: '/organization/user/page',
  UserList: '/organization/user/list',
  UserInfo: '/organization/user/info',
	RolePage: '/organization/role/list',
	UserInfos:'/organization/user/info/multi'
}

export const getOrganizationTree = (params) => {
  return http.get(api.OrganizationTree, {
    params
  })
}

export const getUserPage = (params) => {
  return http.get(api.UserPage, {
    params
  })
}

export const getAllUserList = () => {
  return http.get(api.UserList)
}

/**
 * 根据用户id 获取用户信息
 */
export const getUserInfoById = (id) => {
  return http.get(api.UserInfo, {
    params: {
      id
    }
  })
}

/**
 * 根据用户id 获取部门信息
 */
export const getOrganizationInfo = (id) => {
  return http.get(api.OrganizationInfo, {
    params: {
      id
    }
  })
}

export const getRolePage = (params) => {
  return http.get(api.RolePage, {
    params
  })
}

/**
 * 根据id查用户详情
 */
export function getUsersInfo(params) {
	return http.post(api.UserInfos,
		params
	);
}