import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'errorNo',
    label: '异常报告编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'errorLevel',
    label: '异常等级',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1688808042268565506' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'errorState',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { label: '待发起', value: '0', key: 1 },
        { label: '审核中', value: '1', key: 2 },
        { label: '审核完成', value: '2', key: 3 },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'reportNo',
    label: '成品检验报编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'reportName',
    label: '成品检验报告名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'disJudge',
    label: '处置判定',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1688808244736008194' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'judgeResult',
    label: '判定依据',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
        apiParams: [
          { tableInfo: [], title: 'Query Params', key: '1' },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getCheckStandard',
        apiId: '6967f0799cec4087bbfacae79faa0606',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  // {
  //   field: 'createUserId',
  //   label: '异常报告创建人',
  //   component: 'User',
  //   componentProps: {
  //     suffix: 'ant-design:setting-outlined',
  //     placeholder: '请选择',
  //   },
  //   colProps: { span: 8 },
  // },

  // {
  //   field: 'createDate',
  //   label: '异常报告创建时间',
  //   component: 'Info',
  //   colProps: { span: 8 },
  // },

  // {
  //   field: 'remark',
  //   label: '异常描述',
  //   component: 'Input',
  //   colProps: { span: 8 },
  // },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'errorNo',
    title: '异常报告编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'errorLevel',
    title: '异常等级',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'reportNo',
    title: '成品检验报编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'reportName',
    title: '成品检验报告名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'disJudge',
    title: '处置判定',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'judgeResult',
    title: '判定依据',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '异常报告创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '异常报告创建时间',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'errorState',
    title: '状态',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '异常描述',
    componentType: 'textarea',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '130px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '14a5e4c51fe04b7e9a33fb033688c096',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '成品检验报告信息',
      componentProps: {
        defaultValue: '成品检验报告信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '9f8ff71bbd3e4818a68d829f4e9cc432',
      field: 'reportId',
      label: '成品检验报告ID',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        ifShow: false,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入成品检验报告ID',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '8fcc6c87dd5741d7a19a724676a1eb83',
      field: 'reportNo',
      label: '成品检验报编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        ifShow: true,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入成品检验报编码',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '55a772c2fd81491f96b89bb761e27bd4',
      field: 'reportName',
      label: '成品检验报告名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        ifShow: true,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入成品检验报告抬头',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '88eee11144434ce2a6d5ef39c0f9b245',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '异常数据',
      componentProps: {
        defaultValue: '异常数据',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '265ee24badd84525bd631cea9ade286c',
      label: '',
      field: 'mesQbFinishErrorDetailList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesQbFinishErrorDetailList',

        columns: [
          {
            key: 'dabeba3007b241c399397f8ae89efc00',
            title: '工单编号',
            dataIndex: 'workNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'work_no',
            },
          },
          {
            key: 'bed7c973cd3f441b9369b9085cd5dd7a',
            title: '物料ID',
            dataIndex: 'materialId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'material_id',
            },
          },
          {
            key: 'ecbc6fbab18e4dfaa657459d088d91e3',
            title: '物料编号',
            dataIndex: 'materialNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'material_no',
            },
          },
          {
            key: '2f7136e8490b4a97b342bcc936d1a441',
            title: '物料名称',
            dataIndex: 'materialName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'material_name',
            },
          },
          {
            key: '17cccbb142164484ad4f1ff6e79c773e',
            title: '销售单ID',
            dataIndex: 'saleId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'sale_id',
            },
          },
          {
            key: '64c7df03224c4d9a993c090307382670',
            title: '销售订单号',
            dataIndex: 'saleNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'sale_no',
            },
          },
          {
            key: 'd8b0e941d0b547629e04d63918c21e92',
            title: '车间',
            dataIndex: 'carId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: true,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/mesFactory',
                method: 'GET',
                apiId: '6b4b40b3db664831b709f56bc98a7f04',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'factory_type',
                        value: '1',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'factory_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'car_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'parent_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              prestrainField: 'car_id',
            },
          },
          {
            key: '3016ddefad32472fabd06422b4f605ec',
            title: '基准值',
            dataIndex: 'referenceValue',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'reference_value',
            },
          },
          {
            key: 'd6bc6bfecc1f4da693421b92c14888d3',
            title: '上公差',
            dataIndex: 'upTolerance',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'up_tolerance',
            },
          },
          {
            key: '541a8b3c35ca4b7cbebe35814509d5be',
            title: '下公差',
            dataIndex: 'downTolerance',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'down_tolerance',
            },
          },
          {
            key: '1b304611b4cd426982e531051cc9118e',
            title: '测量值',
            dataIndex: 'measuredValue',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'measured_value',
            },
          },
          {
            key: '34d59d103b2040a2afeee0f92762cd49',
            title: '不良数',
            dataIndex: 'errorNum',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'error_num',
            },
          },
          {
            key: '9cfecdf3f1ad41e887ba8fd79cf403a4',
            title: '不良处理方式',
            dataIndex: 'errorMethod',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'error_method',
            },
          },
          {
            key: '83bc6b1a5a794e3089bbbd1e74e85dc9',
            title: '附件',
            dataIndex: 'imgFile',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'img_file',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {
          path: '/mes/getFinishDetailList',
          method: 'GET',
          apiId: 'copy1691475380638d69749',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: '',
                  description: '回显字段',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'code',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'queryType',
                  value: null,
                  description: '查询类型',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'report_id',
                  value: 'report_id',
                  description: '报告ID',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'data',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(report_id!=null&&report_id!=""){ \r\n    condition+=" and report_id=#{report_id}";\r\n}\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.work_no AS label,t.* FROM mes_qb_finish_detail t where 1=1  "+condition)',
          outputParams: [
            { tableTitle: '工单编号', name: 'work_no' },
            { tableTitle: '物料编号', name: 'material_no' },
            { tableTitle: '物料名称', name: 'material_name' },
            { tableTitle: '销售订单号', name: 'sale_no' },
            { tableTitle: '测量值', name: 'measured_value' },
            { tableTitle: '不良数', name: 'error_num' },
            { tableTitle: '不良处理方式', name: 'error_method' },
          ],
        },
        itemId: '',
        dicOptions: [],
        useSelectButton: true,
        useAddButton: false, //不显示新增按钮
        buttonName: '选择',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
    {
      key: 'b09f124fd0bb48d69d69db8784d996a2',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '异常报告填写',
      componentProps: {
        defaultValue: '异常报告填写',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'cf73476fa59c4b94ba6818b50df9bbc0',
      field: 'errorNo',
      label: '异常报告编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        col: 8,
        prefix: '',
        ifShow: true,
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '异常报告编码请输入异常报告编码',
        addonBefore: '',
        autoCodeRule: 'mesFinishErrorNo',
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '399d82c9388c417c9023499a498459f8',
      field: 'isSysNum',
      label: '使用系统编号',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        col: 4,
        defaultSelect: '1',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '使用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "const code='errorNo';\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        span: '',
        style: {},
      },
    },
    {
      key: '48539527c5f84919a0a64bc44b37592c',
      field: 'remark',
      label: '异常描述',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        ifShow: true,
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入异常描述',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '05cd901b65c543c392d7ccb4c02d71ff',
      field: 'errorLevel',
      label: '异常等级',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'name',
        datasourceType: 'dic',
        dicOptions: [],
        showSearch: true,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckStandard',
          apiId: '6967f0799cec4087bbfacae79faa0606',
        },
        disabled: false,
        placeholder: '请选择异常等级',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        params: { itemId: '1688808042268565506' },
        itemId: '1688808042268565506',
        style: { width: '100%' },
      },
    },
    {
      key: '72b31afb7b764b36847ee409dce8ca25',
      field: 'disJudge',
      label: '处置判定',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'name',
        datasourceType: 'dic',
        dicOptions: [],
        showSearch: true,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckStandard',
          apiId: '6967f0799cec4087bbfacae79faa0606',
        },
        disabled: false,
        placeholder: '请选择处置判定',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        params: { itemId: '1688808244736008194' },
        itemId: '1688808244736008194',
        style: { width: '100%' },
      },
    },
    {
      key: '60992f21072f47fab86fd6a00083a596',
      field: 'judgeResult',
      label: '判定依据',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: true,
        required: true,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: true,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_qb_checkstandard where state=1 "+condition)',
          apiParams: [
            { tableInfo: [], title: 'Query Params', key: '1' },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getCheckStandard',
          apiId: '6967f0799cec4087bbfacae79faa0606',
        },
        disabled: false,
        placeholder: '请选择判定依据',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '04815c4f50d446ac86291e4a05eb719f',
      field: 'errorState',
      label: '状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        clearable: false,
        defaultSelect: '0',
        rules: [],
        ifShow: true,
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        itemId: '1686656230883135490',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {},
        disabled: true,
        placeholder: '',
        staticOptions: [
          { label: '待发起', value: '0', key: 1 },
          { label: '审核中', value: '1', key: 2 },
          { label: '审核完成', value: '2', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '0bc67be6d9ea41e29ddb3192f4617864',
      field: 'createUserId',
      label: '异常报告创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        ifShow: true,
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ecff667615854517ae49a241e1b6642e',
      field: 'createDate',
      label: '异常报告创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        col: 12,
        ifShow: true,
        showLabel: true,
        infoType: 3,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
