import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProSchedule分页参数 模型
 */
export interface MesProSchedulePageParams extends BasicPageParams {
  scheNo: string;

  scheName: string;

  publishState: string;

  finishState: string;

  createDateStart: string;
  createDateEnd: string;

  createUserId: string;

  remark: string;
}

/**
 * @description: MesProSchedule分页返回值模型
 */
export interface MesProSchedulePageModel {
  id: string;

  scheNo: string;

  scheName: string;

  createUserId: string;

  createDate: string;

  publishState: string;

  finishState: string;

  remark: string;
}

/**
 * @description: MesProSchedule表类型
 */
export interface MesProScheduleModel {
  id: number;

  isSysNum: string;

  scheNo: string;

  scheName: string;

  remark: string;

  publishState: number;

  finishState: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProSchedule分页返回值结构
 */
export type MesProSchedulePageResult = BasicFetchResult<MesProSchedulePageModel>;
