
import { MesCollectionSchemePageModel, MesCollectionSchemePageParams, MesCollectionSchemePageResult } from './model/CjfaModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/cjfa/page',
  List = '/jcsj/cjfa/list',
  Info = '/jcsj/cjfa/info',
  MesCollectionScheme = '/jcsj/cjfa',
  
  
  
}

/**
 * @description: 查询MesCollectionScheme分页列表
 */
export async function getMesCollectionSchemePage(params: MesCollectionSchemePageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesCollectionSchemePageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesCollectionScheme信息
 */
export async function getMesCollectionScheme(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesCollectionSchemePageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesCollectionScheme
 */
export async function addMesCollectionScheme(mesCollectionScheme: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesCollectionScheme,
      params: mesCollectionScheme,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesCollectionScheme
 */
export async function updateMesCollectionScheme(mesCollectionScheme: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesCollectionScheme,
      params: mesCollectionScheme,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesCollectionScheme（批量删除）
 */
export async function deleteMesCollectionScheme(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesCollectionScheme,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




