import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
enum Api {
  Data = '/caseErpStock/caseErpInstoreLog/statistical-data',
  Doc = '/caseErpStock/caseErpInstoreLog/doc-analysis',
  DocOut = '/caseErpStock/caseErpInstoreLog/doc-analysis-out',
  Trend = '/caseErpStock/caseErpInstoreLog/trend',
  TrendOut = '/caseErpStock/caseErpInstoreLog/trend-out',
  Warn = '/caseErpStock/caseErpInstoreLog/warn',
  Materials = '/caseErpStock/caseErpInstoreLog/materials',
}

/**
 * @description: 基础数据
 */
export async function getDataInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Data,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询月入库分析
 */
export async function getDocInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Doc,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询月出库分析
 */
export async function getDocOutInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.DocOut,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询入库数量增长趋势
 */
export async function getTrendInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Trend,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询出库数量增长趋势
 */
export async function getTrendOutInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.TrendOut,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询预警类型占比
 */
export async function getWarnInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Warn,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询在库原材料占比
 */
export async function getMaterialsInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Materials,
    },
    {
      errorMessageMode: mode,
    },
  );
}
