import {
  http
} from '@/common/request/index.js'; // 局部引入

const api = {
  MultiInfo: '/organization/user/info/multi',
  uploadUrl: '/system/oss/upload-base64',
  StampList: '/system/stamp/page',
	roleInfo:'/organization/role/info/multi'
}

export const getUserMulti = (ids) => {
  return http.post(api.MultiInfo, ids.split(','))
}

export const uploadApi = (baseString) => {
  return http.post(api.uploadUrl,{ baseString });
}

export const getStampPage = (type, params) => {
  return http.get(api.StampList, {
    params: { stampType: type, ...params },
  })
}

export const getRoleMulti= (ids) => {
  return http.get( api.roleInfo, {
    params: {ids},
  }  )
}
