import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'processCode',
    label: '工序编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'processName',
    label: '工序名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'processType',
    label: '工序类型',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getProcessTypeList',
        method: 'GET',
        apiId: 'copy1691136591484d72056',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,type_name AS label FROM mes_process_type where state=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'createUserId',
    label: '创建人',
    component: 'User',
    componentProps: {
      multiple: false,
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'createDate',
    label: '创建时间',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'processCode',
    title: '工序编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'processName',
    title: '工序名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'processType',
    title: '工序类型',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '描述',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '011d97d8e2f54aad97ffc50676961ae2',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '基础信息',
      componentProps: {
        defaultValue: '基础信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '5550a0198fff43bb9314520e522f7eaf',
      field: 'processCode',
      label: '工序编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请输入',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        showLabel: true,
        autoCodeRule: 'mesprocessNo',
        required: true,
        col: 8,
        style: { width: '100%' },
      },
    },
    {
      key: 'd764d532a75f44c4aaacfb6d9c245a85',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        span: '',
        showLabel: true,
        disabled: false,
        staticOptions: [{ key: 1, label: '用系统编号', value: '1' }],
        datasourceType: 'staticData',
        defaultSelect: '1',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {
          change:
            "const code='processCode';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        col: 4,
        style: {},
      },
    },
    {
      key: 'fe7a419611064ee2a6de1b46a9bd8d82',
      field: 'processName',
      label: '工序名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '40875ddf25494aa5aee882626b8884a0',
      field: 'processType',
      label: '工序类型',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getProcessTypeList',
          method: 'GET',
          apiId: 'copy1691136591484d72056',
          apiParams: [
            { key: '1', title: 'Query Params', tableInfo: [] },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n// if(data_type!=null&&data_type!=""){ \r\n//     condition+=" and data_type=#{data_type}";\r\n// }\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,type_name AS label FROM mes_process_type where state=1 "+condition)',
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'c40f4e7b42c24ffa87fed2712f53e69a',
      field: 'remark',
      label: '描述',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入描述',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '4bafe5e191ba43598414b2f1d2ede5d8',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '1a55746a8f28493d9b592adddfc531d6',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'b2c1378f2fbd4434be220f55b2e40fde',
      field: 'imgFile',
      label: '附件',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        span: '',
        defaultValue: [],
        accept: '',
        maxNumber: 5,
        maxSize: 5,
        showLabel: true,
        multiple: false,
        disabled: false,
        required: false,
        events: {},
      },
    },
    {
      key: 'dd943ae66fae4fd0ad37877202db19c6',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '工位绑定',
      componentProps: {
        defaultValue: '工位绑定',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '5ce5e7456b76496186a07d511d50905b',
      label: '请根据实际需要是否需要将工序绑定工位',
      field: 'mesProcessStationList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesProcessStationList',
        columns: [
          {
            key: '8ef89454624244e6bc31877fa945d363',
            title: '工位ID',
            dataIndex: 'stationId',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入工位ID',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'id',
            },
          },
          {
            key: '878920ca15ef47559fb2802ee2e88a6f',
            title: '工位编码',
            dataIndex: 'stationCode',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入工位编码',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'factory_code',
            },
          },
          {
            key: 'a52c2c812da645479bcffdb0203e3a60',
            title: '工位名称',
            dataIndex: 'stationName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入工位名称',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'factory_name',
            },
          },
          {
            key: 'a37c1bf0d9f0407eaf2b1a4aa1f4610f',
            title: '所属工厂',
            dataIndex: 'factoryId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: true,
              staticOptions: [],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/mesFactory',
                method: 'GET',
                apiId: '6b4b40b3db664831b709f56bc98a7f04',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'factory_type',
                        value: '0',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'factory_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'car_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'parent_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              prestrainField: 'factory_id',
            },
          },
          {
            key: '836fe6eec90c4016a55a4137191f10a3',
            title: '所属车间',
            dataIndex: 'carId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: true,
              staticOptions: [],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/mesFactory',
                method: 'GET',
                apiId: '6b4b40b3db664831b709f56bc98a7f04',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'factory_type',
                        value: '1',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'factory_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'car_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'parent_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              prestrainField: 'car_id',
            },
          },
          {
            key: '7963048c9e6148f798ddf872394f5500',
            title: '所属产线',
            dataIndex: 'lineId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '请选择',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: true,
              staticOptions: [],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/mesFactory',
                method: 'GET',
                apiId: '6b4b40b3db664831b709f56bc98a7f04',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'factory_type',
                        value: '2',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'factory_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'car_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'parent_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label,t.* FROM mes_base_factory t where 1=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              prestrainField: 'line_id',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '3',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'parent_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_code,\'-\',factory_name) AS label FROM mes_base_factory where 1=1 "+condition)',
          outputParams: [
            { tableTitle: '编码', name: 'factory_code' },
            { tableTitle: '名称', name: 'factory_name' },
            { tableTitle: '所属工厂', name: 'fac_name' },
            { tableTitle: '所属车间', name: 'car_name' },
            { tableTitle: '所属产线', name: 'line_name' },
          ],
        },
        itemId: '',
        dicOptions: [],
        useSelectButton: true,
        useAddButton: false, //不显示新增按钮
        buttonName: '新增',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
    {
      key: '6b4da1f029f24f5baf5c62b8f9f3bfe0',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '物料配置',
      componentProps: {
        defaultValue: '物料配置',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '1be422aa7255451a8ba6e901442a4149',
      label: '这里配置的是该工序的输入物料',
      field: 'mesProcessMaterialList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesProcessMaterialList',
        columns: [
          {
            key: '50956cd0cd6b475b95c7be46f6359810',
            title: '物料ID',
            dataIndex: 'materialId',
            componentType: 'MultiplePopup',
            show: false,
            componentProps: {
              popupType: 'associate',
              width: '100%',
              span: '',
              placeholder: '请选择物料ID',
              showLabel: true,
              disabled: true,
              datasourceType: 'api',
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/getMaterialList',
                method: 'GET',
                apiId: '87c017a4baba48909380e9ca3e38359d',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'keyword',
                        value: null,
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'showLabel',
                        value: 'code',
                        description: '回显字段：code/name',
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: 'name',
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(showLabel!=null&&showLabel=="code"){ \r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}else{\r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.NAME AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}\r\n',
                outputParams: [
                  {
                    name: 'code',
                    tableTitle: '物料编码',
                    bindField: 'material_code',
                    show: true,
                    width: 150,
                  },
                  {
                    name: 'name',
                    tableTitle: '物料名称',
                    bindField: 'material_name',
                    show: true,
                    width: 150,
                  },
                  {
                    name: 'type_name',
                    tableTitle: '物料类别',
                    bindField: 'material_type',
                    show: true,
                    width: 150,
                  },
                  {
                    name: 'property_name',
                    tableTitle: '物料属性',
                    bindField: 'material_attr',
                    show: true,
                    width: 150,
                  },
                  {
                    name: 'unit_id',
                    tableTitle: '单位',
                    bindField: 'unity',
                    show: true,
                    width: 150,
                  },
                ],
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
              prestrainField: 'id',
            },
          },
          {
            key: '22142d4ecc3243c8b09b8586c46fa685',
            title: '物料编码',
            dataIndex: 'materialCode',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物料编码',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'code',
            },
          },
          {
            key: '4e949453ad404ad899bd82215c0bbfc7',
            title: '物料名称',
            dataIndex: 'materialName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物料名称',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'name',
            },
          },
          {
            key: 'a4f8f9f64bb84dfcb63ec9545271ac94',
            title: '物料类别',
            dataIndex: 'materialType',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物料类别',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'type_name',
            },
          },
          {
            key: 'fc3102c8a36c4d90842d9d1e7aed55e0',
            title: '物料属性',
            dataIndex: 'materialAttr',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物料属性',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'property_name',
            },
          },
          {
            key: 'f14e1f8d24dd49638b68524b03de5721',
            title: '单位',
            dataIndex: 'unity',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入单位',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: true,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'unit_name',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {
          path: '/mes/getMaterialList',
          method: 'GET',
          apiId: '87c017a4baba48909380e9ca3e38359d',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: 'code',
                  description: '回显字段：code/name',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'name',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(showLabel!=null&&showLabel=="code"){ \r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}else{\r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.NAME AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}\r\n',
          outputParams: [
            { tableTitle: '物料编码', name: 'code' },
            { tableTitle: '物料名称', name: 'name' },
            { tableTitle: '物料类别', name: 'type_name' },
            { tableTitle: '物料属性', name: 'property_name' },
            { tableTitle: '单位', name: 'unit_name' },
          ],
        },
        itemId: '',
        dicOptions: [],
        useSelectButton: true,
        useAddButton: false, //不显示新增按钮
        buttonName: '新增',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
    {
      key: 'ec845c2087da4b79a82e0c7dbc11aae5',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '工时信息',
      componentProps: {
        defaultValue: '工时信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '13d638a896e546209a7efd3c3975ca16',
      field: 'standardHour',
      label: '标准工时',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入标准工时',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '分钟',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '3b150ab602f94b3bab0f9ac820d202c9',
      field: 'auxiliaryHour',
      label: '辅助工时',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入辅助工时',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '分钟',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '98e7f6c5bd8440ddb9125fa1229c86e8',
      field: 'processCost',
      label: '工序成本',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入工序成本',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '元',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '1ab3c484b6e146daa8990d820aeeb06b',
      field: 'processPrice',
      label: '工序单价',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入工序单价',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '元',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '079f4099981f4ed8a7768115da903f21',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '技术参数',
      componentProps: {
        defaultValue: '技术参数',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '0436cad512df42c0a577d115f7bae30c',
      label: '',
      field: 'mesProcessParamList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesProcessParamList',
        columns: [
          {
            key: '4287f263213144798502431bc77898fa',
            title: '参数名称',
            dataIndex: 'paramName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '参数名称请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: true,
              rules: [],
              events: {},
            },
          },
          {
            key: 'ff15175b0b074e5db3ac8f43b5eaf5af',
            title: '参数值',
            dataIndex: 'paramValue',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: null,
              min: 0,
              //max: 100,
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: true,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
