import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import {
  FunctionAuthPageModel,
  FunctionAuthParamsModel,
  PageListSearchModel,
  RelationListModel,
} from './model';

enum Api {
  List = '/authority/data-auth-table/page',
  RelationList = '/authority/menu-table-relation/list',
  Save = '/authority/data-auth-table/save',
  DataAuth = '/authority/data-auth-table',
}

/**
 * @description: 查询功能权限列表（分页）
 */
export async function getFunctionAuthList(
  params?: PageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<FunctionAuthPageModel[]>(
    {
      url: Api.List,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增、编辑功能权限
 */
export async function updateFunctionAuth(
  data: FunctionAuthParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<number>(
    {
      url: Api.Save,
      data,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除功能权限（批量删除）
 */
export async function deleteFunctionAuth(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.DataAuth,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取功能名称及表名关联信息
 */
export async function getTableRelationList(params, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<RelationListModel[]>(
    {
      url: Api.RelationList,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
