import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProOrderworkStep分页参数 模型
 */
export interface MesProOrderworkStepPageParams extends BasicPageParams {
  workId: string;

  workNo: string;

  taskNum: string;

  sendNum: string;

  stepId: string;

  stepNo: string;

  stepName: string;
}

/**
 * @description: MesProOrderworkStep分页返回值模型
 */
export interface MesProOrderworkStepPageModel {
  id: string;

  workId: string;

  workNo: string;

  taskNum: string;

  sendNum: string;

  stepId: string;

  stepNo: string;

  stepName: string;
}

/**
 * @description: MesProOrderworkStep表类型
 */
export interface MesProOrderworkStepModel {
  id: number;

  workId: string;

  workNo: string;

  stepId: string;

  stepNo: string;

  stepName: string;

  taskNum: string;

  stepPrice: string;

  sendNum: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesProOrderworkStepuserList?: MesProOrderworkStepuserModel;
}

/**
 * @description: MesProOrderworkStepuser表类型
 */
export interface MesProOrderworkStepuserModel {
  id: number;

  stepId: string;

  sendUser: string;

  sendNum: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProOrderworkStep分页返回值结构
 */
export type MesProOrderworkStepPageResult = BasicFetchResult<MesProOrderworkStepPageModel>;