import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesQbSemifinError分页参数 模型
 */
export interface MesQbSemifinErrorPageParams extends BasicPageParams {
  errorNo: string;

  errorLevel: string;

  errorState: string;

  reportNo: string;

  reportName: string;

  disJudge: string;

  judgeResult: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;

  remark: string;
}

/**
 * @description: MesQbSemifinError分页返回值模型
 */
export interface MesQbSemifinErrorPageModel {
  id: string;

  errorNo: string;

  errorLevel: string;

  disJudge: string;

  judgeResult: string;

  reportNo: string;

  reportName: string;

  createUserId: string;

  createDate: string;

  errorState: string;

  remark: string;
}

/**
 * @description: MesQbSemifinError表类型
 */
export interface MesQbSemifinErrorModel {
  id: number;

  isSysNum: string;

  reportId: string;

  reportNo: string;

  reportName: string;

  errorNo: string;

  errorLevel: string;

  disJudge: string;

  judgeResult: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesQbSemifinErrorDetailList?: MesQbSemifinErrorDetailModel;
}

/**
 * @description: MesQbSemifinErrorDetail表类型
 */
export interface MesQbSemifinErrorDetailModel {
  id: number;

  errorId: number;

  reportId: number;

  reportNo: string;

  reportName: string;

  errorNo: string;

  saleId: string;

  saleNo: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  workshop: string;

  referenceValue: string;

  upTolerance: string;

  downTolerance: string;

  measuredValue: string;

  errorNum: string;

  errorMethod: string;

  imgFile: string;

  remark: string;

  errorState: string;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesQbSemifinError分页返回值结构
 */
export type MesQbSemifinErrorPageResult = BasicFetchResult<MesQbSemifinErrorPageModel>;
