import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
import {
  AlarmPageListSearchModel,
  AlarmPageListResultModel,
  AlarmUpdateParamsModel,
  AlarmCheckModel,
  AlarmInfoModel,
} from './model';

enum Api {
  Page = '/caseErpDevice/caseErpDeviceWarn/page',
  Alarm = '/caseErpDevice/caseErpDeviceWarn',
  Info = '/caseErpDevice/caseErpDeviceWarn/info',
  Check = '/caseErpDevice/caseErpDeviceWarn/check',
  Export = '/caseErpDevice/caseErpDeviceWarn/export',
}

/**
 * @description: 查询设备告警（分页）
 */
export async function getDeviceAlarmPageList(
  params?: AlarmPageListSearchModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<AlarmPageListResultModel>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 修改设备告警
 */
export async function updateDeviceAlarm(
  params: AlarmUpdateParamsModel,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<number>(
    {
      url: Api.Alarm,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除设备告警
 */
export async function deleteDeviceAlarm(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<number>(
    {
      url: Api.Alarm,
      data: id,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询设备告警详情
 */
export async function getDeviceAlarmInfo(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<AlarmInfoModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查看设备告警详情
 */
export async function getDeviceAlarmCheck(id: string, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<AlarmCheckModel>(
    {
      url: Api.Check,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 导出
 */
export async function exportInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'POST',
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}
