
  /**
   * 打电话
   * @param {String<Number>} phoneNumber - 数字字符串
   */
  export function callPhone(phoneNumber = '') {
    let num = phoneNumber.toString();
    uni.makePhoneCall({
      phoneNumber: num,
      fail(err) {
        console.log('makePhoneCall出错', err);
      },
    });
  }

  /**
   * 微信头像
   * @param {String} url -图片地址
   */
 export function checkMPUrl(url) {
    // #ifdef MP
    if (
      url.substring(0, 4) === 'http' &&
      url.substring(0, 5) !== 'https' &&
      url.substring(0, 12) !== 'http://store' &&
      url.substring(0, 10) !== 'http://tmp' &&
      url.substring(0, 10) !== 'http://usr'
    ) {
      url = 'https' + url.substring(4, url.length);
    }
    // #endif
    return url;
  }

  /**
   * getUuid 生成唯一id
   */
 export function getUuid(len = 32, firstU = true, radix = null) {
    const chars = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz'.split('');
    const uuid = [];
    radix = radix || chars.length;

    if (len) {
      // 如果指定uuid长度,只是取随机的字符,0|x为位运算,能去掉x的小数位,返回整数位
      for (let i = 0; i < len; i++) uuid[i] = chars[0 | (Math.random() * radix)];
    } else {
      let r;
      // rfc4122标准要求返回的uuid中,某些位为固定的字符
      uuid[8] = uuid[13] = uuid[18] = uuid[23] = '-';
      uuid[14] = '4';

      for (let i = 0; i < 36; i++) {
        if (!uuid[i]) {
          r = 0 | (Math.random() * 16);
          uuid[i] = chars[i == 19 ? (r & 0x3) | 0x8 : r];
        }
      }
    }
    // 移除第一个字符,并用u替代,因为第一个字符为数值时,该guuid不能用作id或者class
    if (firstU) {
      uuid.shift();
      return `u${uuid.join('')}`;
    }
    return uuid.join('');
  }
 
function encodeString (str) {
	var utf8Array = [];
	for (var i = 0; i < str.length; i++) {
		var charCode = str.charCodeAt(i); // 获得字符的ASCII
		if (charCode < 0x80) {
			utf8Array.push(charCode);
		} else if (charCode < 0x800) {
			utf8Array.push(0xc0 | (charCode >> 6));
			utf8Array.push(0x80 | (charCode & 0x3f));
		} else if (charCode < 0x10000) {
			utf8Array.push(0xe0 | (charCode >> 12));
			utf8Array.push(0x80 | ((charCode >> 6) & 0x3f));
			utf8Array.push(0x80 | (charCode & 0x3f));
		} else {
			utf8Array.push(0xf0 | (charCode >> 18));
			utf8Array.push(0x80 | ((charCode >> 12) & 0x3f));
			utf8Array.push(0x80 | ((charCode >> 6) & 0x3f));
			utf8Array.push(0x80 | (charCode & 0x3f));
		}
	}
	return new Uint8Array(utf8Array);
} 
export function base64Encode (inputString) { 
	const keyStr = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-/="; 
	let inputBytes = encodeString(inputString); 
	let output = ""; 
	let chr1, chr2, chr3, enc1, enc2, enc3, enc4; 
	let i = 0; 
	while (i < inputBytes.length) { 
		chr1 = inputBytes[i++]; 
		chr2 = inputBytes[i++]; 
		chr3 = inputBytes[i++]; 
		enc1 = chr1 >> 2; 
		enc2 = ((chr1 & 3) << 4) | (chr2 >> 4); 
		enc3 = ((chr2 & 15) << 2) | (chr3 >> 6); 
		enc4 = chr3 & 63; 
		if (isNaN(chr2)) { 
			enc3 = enc4 = 64; 
		} else if (isNaN(chr3)) { 
			enc4 = 64; 
		} 
		output += keyStr.charAt(enc1) + keyStr.charAt(enc2) + keyStr.charAt(enc3) + keyStr.charAt(enc4); 
	} 
	return output; 
} 

