import { defineStore } from 'pinia';
import { RuleProcessNodeState, InfoId, InfoItem } from '/@/model/ruleProcessConfig';
import { defaultProcessInfo } from '../config';
import { cloneDeep } from 'lodash-es';

export const useRuleProcessStore = defineStore({
  id: 'rule-process-store',
  state: (): RuleProcessNodeState => ({
    modelId: '',
    info: new Map(),
    infoId: '',
    edgeId: '',
    processInfo: cloneDeep(defaultProcessInfo),
    lastEdgeId: 0,
    lastNodeId: 0,
    cateGorytreeData: [],
  }),

  actions: {
    getInfoId() {
      return this.infoId;
    },
    setEdgeId(val) {
      this.edgeId = val;
    },
    getEdgeId() {
      return this.edgeId;
    },
    setCateGorytreeData(treeData) {
      this.cateGorytreeData = treeData;
    },
    getCateGorytreeData() {
      return this.cateGorytreeData;
    },
    setLastEdgeId(lastEdgeId) {
      this.lastEdgeId = lastEdgeId;
    },
    autoIncrementLastEdgeId() {
      this.lastEdgeId = this.lastEdgeId + 1;
      return this.lastEdgeId;
    },
    setLastNodeId(lastNodeId) {
      this.lastNodeId = lastNodeId;
    },
    autoIncrementLastNodeId() {
      this.lastNodeId = this.lastNodeId + 1;
      return this.lastNodeId;
    },
    initStartProperties(key: InfoId, value: InfoItem) {
      this.info.set(key, value);
    },
    setProcessInfoProperties(processInfo) {
      this.processInfo = processInfo;
    },
    setProperties(key: InfoId, value: any) {
      this.info.set(key, value);
    },
    hasProperties(key: InfoId) {
      return this.info.has(key);
    },
    getProperties(key: InfoId) {
      return this.info.has(key) ? this.info.get(key) : null;
    },
    deleteProperties(key: InfoId) {
      this.infoId = '';
      if (this.info.has(key)) {
        this.info.delete(key);
      }
    },
    setInfoId(infoId: InfoId) {
      this.infoId = infoId;
    },
    deleteInfo(infoId: InfoId) {
      for (const [key] of this.info) {
        if (key === infoId) {
          this.info.delete(key);
        }
      }
      this.setInfoId('');
      this.setEdgeId('');
    },
  },
});
