import { reactive, nextTick } from 'vue';
export default function () {
  const tableOptions: {
    scrollHeight: number;
  } = reactive({
    scrollHeight: 600,
  });
  async function scrollHeight() {
    await nextTick();
    const conTable = document.getElementsByClassName('vben-layout-content');
    if (conTable && conTable.length > 0 && conTable[0]) {
      const searchTable = document.getElementsByClassName('search');
      if (searchTable && searchTable.length > 0 && searchTable[0]) {
        tableOptions.scrollHeight = conTable[0].clientHeight - 220 - searchTable[0].clientHeight;
      } else {
        tableOptions.scrollHeight = conTable[0].clientHeight - 180;
      }
    } else {
      tableOptions.scrollHeight = 400;
    }
  }
  return {
    tableOptions,
    scrollHeight,
  };
}
