
import { MesProductionPlanPageModel, MesProductionPlanPageParams, MesProductionPlanPageResult } from './model/ScjhModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/scgl/scjh/page',
  List = '/scgl/scjh/list',
  Info = '/scgl/scjh/info',
  MesProductionPlan = '/scgl/scjh',
  
  
  
}

/**
 * @description: 查询MesProductionPlan分页列表
 */
export async function getMesProductionPlanPage(params: MesProductionPlanPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductionPlanPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProductionPlan信息
 */
export async function getMesProductionPlan(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductionPlanPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProductionPlan
 */
export async function addMesProductionPlan(mesProductionPlan: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProductionPlan,
      params: mesProductionPlan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProductionPlan
 */
export async function updateMesProductionPlan(mesProductionPlan: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProductionPlan,
      params: mesProductionPlan,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProductionPlan（批量删除）
 */
export async function deleteMesProductionPlan(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProductionPlan,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




