import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesWarehouseOut分页参数 模型
 */
export interface MesWarehouseOutPageParams extends BasicPageParams {
  outCode: string;

  outType: string;

  outName: string;

  outDate: string;

  recUnit: string;

  recUser: string;

  outStorage: string;

  outDouser: string;

  relevancePro: string;

  remark: string;
}

/**
 * @description: MesWarehouseOut分页返回值模型
 */
export interface MesWarehouseOutPageModel {
  id: string;

  outCode: string;

  outName: string;

  outType: string;

  outDate: string;

  recUnit: string;

  recUser: string;

  outStorage: string;

  outNum: string;

  outPrice: string;

  outDouser: string;

  relevancePro: string;

  remark: string;
}

/**
 * @description: MesWarehouseOut表类型
 */
export interface MesWarehouseOutModel {
  id: number;

  isSysNum: string;

  outCode: string;

  outName: string;

  outType: string;

  outDate: string;

  recUnit: string;

  recUser: string;

  outStorage: string;

  outNum: string;

  outPrice: string;

  outDouser: string;

  relevancePro: string;

  produceId: string;

  produceNo: string;

  saleId: string;

  saleNo: string;

  saleCustomer: string;

  buyId: string;

  buyNo: string;

  supplier: string;

  supplierId: string;

  supplierUser: string;

  supplierPhone: string;

  outFile: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesWarehouseOutDetailList?: MesWarehouseOutDetailModel;
}

/**
 * @description: MesWarehouseOutDetail表类型
 */
export interface MesWarehouseOutDetailModel {
  id: number;

  outId: number;

  productNo: string;

  productName: string;

  productId: string;

  speModel: string;

  unity: string;

  warArea: string;

  locationId: string;

  batchno: string;

  price: string;

  num: string;

  totalPrice: string;

  produceDate: string;

  endDate: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesWarehouseOut分页返回值结构
 */
export type MesWarehouseOutPageResult = BasicFetchResult<MesWarehouseOutPageModel>;
