import { MesProcessTechnologyModel, MesProcessTechnologyPageParams, MesProcessTechnologyPageResult } from './model/ProTechModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/protech/page',
  List = '/mes/protech/list',
  Info = '/mes/protech/info',
  MesProcessTechnology = '/mes/protech',
  
  
}

/**
 * @description: 查询MesProcessTechnology分页列表
 */
export async function getMesProcessTechnologyPage(params: MesProcessTechnologyPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProcessTechnologyPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProcessTechnology信息
 */
export async function getMesProcessTechnology(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProcessTechnologyModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProcessTechnology
 */
export async function addMesProcessTechnology(mesProcessTechnology: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProcessTechnology,
      params: mesProcessTechnology,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProcessTechnology
 */
export async function updateMesProcessTechnology(mesProcessTechnology: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProcessTechnology,
      params: mesProcessTechnology,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProcessTechnology（批量删除）
 */
export async function deleteMesProcessTechnology(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProcessTechnology,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}