import { cloneDeep } from 'lodash-es';
import { RuleProcessListModel } from '/@/api/ruleProcess/model';
import { InfoItem, RuleProcessNodeKey } from '/@/model/ruleProcessConfig';
export const StartId = 'start_id';
export const defaultNodeItem = { label: '默认节点', type: RuleProcessNodeKey.DEFAULT_NODE };
// <!-- 开始节点 -->
// start
export const startNodeItem = {
  id: StartId,
  label: '开始节点',
  type: RuleProcessNodeKey.START_NODE,
};
// <!-- 事件节点 -->
// event
export const eventNodeItem = {
  label: '事件节点',
  type: RuleProcessNodeKey.EVENT_NODE,
  remark: '', //备注
  ruleEvent: 'e',
  eventConfigs: [],
  variableAssignmentConfigs: [], //变量赋值
};
// <!-- 规则节点 -->
// rule
export const ruleNodeItem = {
  label: '规则节点',
  type: RuleProcessNodeKey.RULE_NODE,
  ruleEvent: '', //规则事件
  remark: '', //备注
  paramConfigs: [], //参数列表
  variableAssignmentConfigs: [], //变量赋值
};
// <!-- 选择节点 -->
// select
export const selectNodeItem = {
  label: '选择节点',
  type: RuleProcessNodeKey.SELECT_NODE,
  remark: '', //备注
  ruleEvent: 's',
  paramConfigs: [],
  variableAssignmentConfigs: [], //变量赋值
};
// <!-- 条件节点 -->
// condition
export const conditionNodeItem = {
  label: '条件节点',
  type: RuleProcessNodeKey.CONDITION_NODE,
  remark: '', //备注
  ruleEvent: 'i',
  paramConfigs: [],
  variableAssignmentConfigs: [], //变量赋值
};
// <!-- for循环节点 -->
// for
export const forNodeItem = {
  label: 'for循环节点',
  type: RuleProcessNodeKey.FOR_NODE,
  variablesAndValues: '', //变量与值
  formulaContent: '', // 公式内容
  remark: '', //备注
  ruleEvent: 'f',
  eventConfigs: [], //事件配置
  variableAssignmentConfigs: [], //变量赋值
};
// <!-- while循环节点 -->
// while
export const whileNodeItem = {
  label: 'while循环节点',
  type: RuleProcessNodeKey.WHILE_NODE,
  variablesAndValues: '', //变量与值
  formulaContent: '', // 公式内容
  remark: '', //备注
  ruleEvent: 'w',
  eventConfigs: [], //事件配置
  variableAssignmentConfigs: [], //变量赋值
};
// <!-- 运维节点 -->
// devOp
export const devOpsNodeItem = {
  label: '运维节点',
  ruleEvent: 'o',
  type: RuleProcessNodeKey.DEV_OPS_NODE,
  devOpsConfigs: [], //运维配置
};
// draggedTypeData的配置
export function getDraggedTypeData(nodeId, type: RuleProcessNodeKey | null): InfoItem {
  if (type == RuleProcessNodeKey.EVENT_NODE) {
    return { id: nodeId, ...cloneDeep(eventNodeItem) };
  } else if (type == RuleProcessNodeKey.RULE_NODE) {
    return { id: nodeId, ...cloneDeep(ruleNodeItem) };
  } else if (type == RuleProcessNodeKey.SELECT_NODE) {
    return { id: nodeId, ...cloneDeep(selectNodeItem) };
  } else if (type == RuleProcessNodeKey.CONDITION_NODE) {
    return { id: nodeId, ...cloneDeep(conditionNodeItem) };
  } else if (type == RuleProcessNodeKey.FOR_NODE) {
    return { id: nodeId, ...cloneDeep(forNodeItem) };
  } else if (type == RuleProcessNodeKey.WHILE_NODE) {
    return { id: nodeId, ...cloneDeep(whileNodeItem) };
  } else if (type == RuleProcessNodeKey.DEV_OPS_NODE) {
    return { id: nodeId, ...cloneDeep(devOpsNodeItem) };
  } else {
    return { id: nodeId, ...cloneDeep(defaultNodeItem) };
  }
}
// 默认开始节点
export const defaultNodes = [
  {
    id: StartId,
    type: RuleProcessNodeKey.START_NODE,
    data: startNodeItem,
    position: { x: 60, y: 420 },
    class: 'light',
  },
];

export const defaultProcessInfo: RuleProcessListModel = {
  id: '',
  name: '',
  code: '',
  itemId: '',
  remark: '',
  jsonContent: '',
  processParamConfigs: [],
  elValue: '',
};

export const NodeNameByType: Map<RuleProcessNodeKey, any> = new Map([
  [RuleProcessNodeKey.START_NODE, '开始节点'],
  [RuleProcessNodeKey.EVENT_NODE, '事件节点'],
  [RuleProcessNodeKey.RULE_NODE, '规则节点'],
  [RuleProcessNodeKey.SELECT_NODE, '选择节点'],
  [RuleProcessNodeKey.CONDITION_NODE, '条件节点'],
  [RuleProcessNodeKey.FOR_NODE, 'for循环节点'],
  [RuleProcessNodeKey.WHILE_NODE, 'while循环节点'],
  [RuleProcessNodeKey.DEV_OPS_NODE, '运维节点'],
]);
// 规则流程分类id
export enum RuleProcessCategory {
  ID = '1419276800524425555',
}

export const getNodePrefix = 'node_';
export const getEdgePrefix = 'edge_';
