import { Component, defineAsyncComponent } from 'vue';
import { DesktopComponent } from '/@/enums/desktop';
export default function () {
  const Chart = defineAsyncComponent({
    loader: () => import('./../components/designer/chart/Chart.vue'),
  });
  const ChartBar = defineAsyncComponent({
    loader: () => import('./../components/designer/infos/ChartBar.vue'),
  });
  const MixLineBar = defineAsyncComponent({
    loader: () => import('./../components/designer/chart/MixLineBar.vue'),
  });

  const Dashboard = defineAsyncComponent({
    loader: () => import('./../components/designer/infos/Dashboard.vue'),
  });
  const MyTask = defineAsyncComponent({
    loader: () => import('./../components/designer/infos/MyTask.vue'),
  });
  const TodoList = defineAsyncComponent({
    loader: () => import('./../components/designer/infos/TodoList.vue'),
  });
  const Modules = defineAsyncComponent({
    loader: () => import('./../components/designer/infos/Modules.vue'),
  });
  const Banner = defineAsyncComponent({
    loader: () => import('./../components/designer/infos/Banner.vue'),
  });
  const componentByType = new Map<DesktopComponent, Component>([
    [DesktopComponent.DASHBOARD, Dashboard],
    [DesktopComponent.BANNER, Banner],
    [DesktopComponent.CHARTLINE, MixLineBar],
    [DesktopComponent.PIE, Chart],
    [DesktopComponent.RADAR, Chart],
    [DesktopComponent.GAUGE, Chart],
    [DesktopComponent.FUNNEL, Chart],
    [DesktopComponent.CHARTBAR, ChartBar],
    [DesktopComponent.MYTASK, MyTask],
    [DesktopComponent.TODOLIST, TodoList],
    [DesktopComponent.MODULES, Modules],
  ]);
  return {
    componentByType,
  };
}
