import {
  CustomCompPageModel,
  CustomCompPageParams,
  CustomCompPageResult,
  CustomCompParams,
} from './model/CustomCompModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/system/customcomp/page',
  List = '/system/customcomp/list',
  Info = '/system/customcomp/info',
  CustomComp = '/system/customcomp',
}

/**
 * @description: 查询CustomComp分页列表
 */
export async function getCustomCompPage(
  params: CustomCompPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<CustomCompPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 查询CustomComp分页列表
 */
export async function getCustomCompList(
  params?: CustomCompParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get(
    {
      url: Api.List,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 获取CustomComp信息
 */
export async function getCustomComp(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<CustomCompPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增CustomComp
 */
export async function addCustomComp(customComp: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.CustomComp,
      params: customComp,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新CustomComp
 */
export async function updateCustomComp(customComp: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.CustomComp,
      params: customComp,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除CustomComp（批量删除）
 */
export async function deleteCustomComp(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.CustomComp,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
