import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProOrderplan分页参数 模型
 */
export interface MesProOrderplanPageParams extends BasicPageParams {
  orderNo: string;

  saleOrderNo: string;

  onlineDate: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;
}

/**
 * @description: MesProOrderplan分页返回值模型
 */
export interface MesProOrderplanPageModel {
  id: string;

  orderNo: string;

  saleOrderNo: string;

  onlineDate: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesProOrderplan表类型
 */
export interface MesProOrderplanModel {
  id: string;
  planId: string;
  isSysNum: string;

  orderId: string;

  orderNo: string;

  planNo: string;

  onlineDate: string;

  saleOrderNo: string;

  priority: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  speModel: string;

  materialType: string;

  materialProperty: string;

  unity: string;

  planNum: string;

  carId: string;

  lineId: string;

  craftId: string;

  planStartDate: string;

  planEndDate: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesProOrderplan2List?: MesProOrderplan2Model;
}

/**
 * @description: MesProOrderplan2表类型
 */
export interface MesProOrderplan2Model {
  id: number;

  isSysNum: string;

  orderId: string;

  orderNo: string;

  planNo: string;

  planId: string;

  onlineDate: string;

  saleOrderNo: string;

  priority: string;

  materialId: string;

  materialNo: string;

  materialName: string;

  speModel: string;

  materialType: string;

  materialProperty: string;

  unity: string;

  planNum: string;

  carId: string;

  lineId: string;

  craftId: string;

  planStartDate: string;

  planEndDate: string;

  remark: string;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProOrderplan分页返回值结构
 */
export type MesProOrderplanPageResult = BasicFetchResult<MesProOrderplanPageModel>;
