import { MesProductModel, MesProductPageParams, MesProductPageResult } from './model/ProductModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/product/page',
  List = '/mes/product/list',
  Info = '/mes/product/info',
  MesProduct = '/mes/product',
  
  
  Export = '/mes/product/export',
}

/**
 * @description: 查询MesProduct分页列表
 */
export async function getMesProductPage(params: MesProductPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProduct信息
 */
export async function getMesProduct(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProductModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProduct
 */
export async function addMesProduct(mesProduct: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProduct,
      params: mesProduct,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProduct
 */
export async function updateMesProduct(mesProduct: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProduct,
      params: mesProduct,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProduct（批量删除）
 */
export async function deleteMesProduct(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProduct,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}



/**
 * @description: 导出MesProduct
 */
export async function exportMesProduct(
  params?: object, 
  mode: ErrorMessageMode = 'modal'
) {
  return defHttp.download(
    {
      url: Api.Export,
      method: 'GET',
      params,
      responseType: 'blob',
    },
    {
      errorMessageMode: mode,
    },
  );
}