import { MesQpProcessPatrolModel, MesQpProcessPatrolPageParams, MesQpProcessPatrolPageResult } from './model/MesProcessPartolModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mesprocesspartol/page',
  List = '/mes/mesprocesspartol/list',
  Info = '/mes/mesprocesspartol/info',
  MesQpProcessPatrol = '/mes/mesprocesspartol',
  
  
}

/**
 * @description: 查询MesQpProcessPatrol分页列表
 */
export async function getMesQpProcessPatrolPage(params: MesQpProcessPatrolPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQpProcessPatrolPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQpProcessPatrol信息
 */
export async function getMesQpProcessPatrol(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQpProcessPatrolModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQpProcessPatrol
 */
export async function addMesQpProcessPatrol(mesQpProcessPatrol: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesQpProcessPatrol,
      params: mesQpProcessPatrol,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQpProcessPatrol
 */
export async function updateMesQpProcessPatrol(mesQpProcessPatrol: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesQpProcessPatrol,
      params: mesQpProcessPatrol,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQpProcessPatrol（批量删除）
 */
export async function deleteMesQpProcessPatrol(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQpProcessPatrol,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}