import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'productNo',
    label: '物品编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'productName',
    label: '物品名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'warehouseId',
    label: '仓库',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getWarehouseList',
        method: 'GET',
        apiId: 'd5acd359b8c6490caa8291712d2a2127',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'data_type',
                value: '0',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: '0',
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'warehouse_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'area_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'parent_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'areaId',
    label: '库区',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getWarehouseList',
        method: 'GET',
        apiId: 'd5acd359b8c6490caa8291712d2a2127',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'data_type',
                value: '1',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: '0',
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'warehouse_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'area_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'parent_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'locationId',
    label: '库位',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getWarehouseList',
        method: 'GET',
        apiId: 'd5acd359b8c6490caa8291712d2a2127',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'data_type',
                value: '2',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: '0',
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'warehouse_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'area_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'parent_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'deType',
    label: '类型',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'productNo',
    title: '物品编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'productName',
    title: '物品名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'deType',
    title: '类型',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'unity',
    title: '单位',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'warehouseId',
    title: '仓库',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'areaId',
    title: '库区',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'locationId',
    title: '库位',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'num',
    title: '在库数量',
    componentType: 'input',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '8d0d24d0272e4bb98b2efccc493ae76e',
      field: 'productNo',
      label: '物品编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入物品编码',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '436c3af3277d45e09168053fd8662107',
      field: 'productName',
      label: '物品名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入物品名称',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '39de633f27c9464c9cece7d8ba7fbca5',
      field: 'deType',
      label: '类型',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入类型',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'f15fe3c7f5d849a09a5c4a7e38fc2f54',
      field: 'unity',
      label: '单位',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入单位',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '795c7b36a74d4c56a2f9437e86a62e5b',
      field: 'warehouseId',
      label: '仓库',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '仓库请选择下拉选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getWarehouseList',
          method: 'GET',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'data_type',
                  value: '0',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: '0',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'warehouse_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'area_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'parent_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '38b9a6877ac44e3986e586688d03175a',
      field: 'areaId',
      label: '库区',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '库区请选择下拉选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getWarehouseList',
          method: 'GET',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'data_type',
                  value: '1',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: '0',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'warehouse_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'area_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'parent_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '91907297c67f495cb1d772763308808e',
      field: 'locationId',
      label: '库位',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '库位请选择下拉选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getWarehouseList',
          method: 'GET',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'data_type',
                  value: '2',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: '0',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'warehouse_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'area_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'parent_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'fd6aa89a32ab46e69e3a3333c035a412',
      field: 'num',
      label: '在库数量',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '在库数量请输入',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
