import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'code',
    label: '检测类别编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'name',
    label: '检测类别',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '状态',
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'code',
    title: '检测类别编码',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'name',
    title: '检测类别',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '51e0d09321e64a94994d9a044b575654',
      field: 'code',
      label: '检测类别编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 20 },
      ifShow: true,
      componentProps: {
        col: 20,
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '检测类别编码',
        addonBefore: '',
        autoCodeRule: 'mesbaseType',
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'e3374c6da55f489faf4027c21e15c799',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        col: 4,
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编码', value: '1', key: 1 }],
        events: {
          change:
            "const code='code';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        span: '',
        style: {},
      },
    },
    {
      key: '0e3b73f9a3604745b30950a453bc973c',
      field: 'name',
      label: '检测类别',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '检测类别请输入',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '3e66cfde7fbc42c49f6167f4ab601bc9',
      field: 'state',
      label: '状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: 'ac92d48fa35c4b7bb204d361868b73cd',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'd01f90d48aa94ea6a1882d7da274bff9',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '4522269298ee409a9a49dd7a7a855d2e',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
