import { DesktopComponent } from '/@/enums/desktop';
import { useI18n } from '/@/hooks/web/useI18n';
const { t } = useI18n();
export const componentTitleFromType = new Map([
  [DesktopComponent.DASHBOARD, t('数据面板')],
  [DesktopComponent.INFORMATION, t('信息列表')],
  [DesktopComponent.CHARTLINE, t('折线/柱状图')],
  [DesktopComponent.PIE, t('饼图')],
  [DesktopComponent.RADAR, t('雷达图')],
  [DesktopComponent.GAUGE, t('仪表盘')],
  [DesktopComponent.FUNNEL, t('漏斗图')],
  [DesktopComponent.CHARTBAR, t('柱状百分比')],
  [DesktopComponent.MYTASK, t('我的任务')],
  [DesktopComponent.TODOLIST, t('待办事项')],
  [DesktopComponent.MODULES, t('常用功能')],
  [DesktopComponent.BUTTON, t('按钮组件')],
  [DesktopComponent.TABLE, t('表格组件')],
  [DesktopComponent.TABSTABLE, t('多表格组件')],
  [DesktopComponent.CATEGORY_STACK, t('甘特图')],
  [DesktopComponent.IMAGE, t('图片')],
  [DesktopComponent.MAP, t('地图')],
  [DesktopComponent.BANNER, t('Banner图')],
  [DesktopComponent.BACKGROUND, t('桌面设计背景配置')],
  [DesktopComponent.TITLE, t('标题')],
  [DesktopComponent.MYIFRAME, t('Iframe')],
]);

export const basicComponents = [
  {
    type: DesktopComponent.TITLE,
    label: t('标题'),
    icon: 'icon2',
  },
  {
    type: DesktopComponent.DASHBOARD,
    label: t('数据'),
    icon: 'icon2',
  },
  {
    type: DesktopComponent.INFORMATION,
    label: t('列表'),
    icon: 'icon3',
  },
  {
    type: DesktopComponent.MYIFRAME,
    label: t('Iframe'),
    icon: 'icon3',
  },
];

export const chartComponents = [
  {
    type: DesktopComponent.CHARTLINE,
    label: t('折/柱'),
    icon: 'icon4',
  },
  {
    type: DesktopComponent.PIE,
    label: t('饼图'),
    icon: 'icon5',
  },
  {
    type: DesktopComponent.RADAR,
    label: t('雷达图'),
    icon: 'icon6',
  },
  {
    type: DesktopComponent.GAUGE,
    label: t('仪表盘'),
    icon: 'icon7',
  },
  {
    type: DesktopComponent.FUNNEL,
    label: t('漏斗图'),
    icon: 'icon8',
  },
  {
    type: DesktopComponent.CHARTBAR,
    label: t('百分比'),
    icon: 'icon9',
  },
  {
    type: DesktopComponent.CATEGORY_STACK,
    label: t('甘特图'),
    icon: 'icon15',
  },
  {
    type: DesktopComponent.IMAGE,
    label: t('图片'),
    icon: 'icon16',
  },
  {
    type: DesktopComponent.MAP,
    label: t('地图'),
    icon: 'icon17',
  },
  {
    type: DesktopComponent.BANNER,
    label: t('Banner图'),
    icon: 'icon18',
  },
];

export const systemComponents = [
  {
    type: DesktopComponent.MYTASK,
    label: t('任务'),
    icon: 'icon10',
  },
  {
    type: DesktopComponent.TODOLIST,
    label: t('待办'),
    icon: 'icon11',
  },
  {
    type: DesktopComponent.MODULES,
    label: t('功能'),
    icon: 'icon12',
  },
  {
    type: DesktopComponent.BUTTON,
    label: t('按钮'),
    icon: 'icon13',
  },
  {
    type: DesktopComponent.TABLE,
    label: t('表格'),
    icon: 'icon14',
  },
  {
    type: DesktopComponent.TABSTABLE,
    label: t('多表格'),
    icon: 'icon14',
  },
];
