import { ComputedRef, Slots } from 'vue';
import type { BasicTableProps, InnerHandlers, TableActionType } from '../types/table';
import { unref, computed, h, Ref } from 'vue';
import TableHeader from '../components/TableHeader.vue';
import { isString } from '/@/utils/is';
import { getSlot } from '/@/utils/helper/tsxHelper';

export function useTableHeader(
  propsRef: ComputedRef<BasicTableProps>,
  slots: Slots,
  handlers: InnerHandlers,
  tabelWidth: Ref<Number>,
  getFormProps: any,
  getBindValues: Recordable,
  tableAction: TableActionType,
  handleSearchInfoChange: Function,
  redoHeight: Function,
  getFormSlotKeys: ComputedRef<string[]>,
  replaceFormSlotKey: Function,
  registerForm: Function,
) {
  const getHasHeader = computed((): Boolean => {
    const { showTitle, showTableSetting, useSearchForm } = unref(propsRef);
    return showTitle || showTableSetting || useSearchForm || slots.toolbar || slots.tableTitle
      ? true
      : false;
  });
  const getHeaderProps = computed((): Recordable => {
    const {
      title,
      showTitle,
      showTableSetting,
      titleHelpMessage,
      tableSetting,
      needDivider,
      isAdvancedQuery,
      querySelectOption,
      objectId,
      listPageMode,
      hasLeftTree,
      leftTreeShow,
    } = unref(propsRef);
    const hideTitle = !slots.tableTitle && !title && !slots.toolbar && !showTableSetting;
    if (hideTitle && !isString(title)) {
      return {};
    }

    const formSlots = {};
    Object.keys(slots).forEach((key) => {
      if (key.startsWith('form-')) {
        formSlots[key] = getSlot(slots, key);
      }
    });

    return {
      title: hideTitle
        ? null
        : () =>
            h(
              TableHeader,
              {
                title,
                showTitle,
                titleHelpMessage,
                showTableSetting,
                listPageMode,
                hasLeftTree,
                leftTreeShow,
                needDivider,
                tableSetting,
                onColumnsChange: handlers.onColumnsChange,
                onPanelShowChange: handlers.onPanelShowChange,
                onTreeShowChange: handlers.onTreeShowChange,
                onRedo: handlers.onRedo,
                tableWidth: tabelWidth.value,
                getFormProps: getFormProps.value,
                getBindValues: getBindValues.value,
                tableAction,
                handleSearchInfoChange,
                redoHeight,
                slots,
                getFormSlotKeys,
                replaceFormSlotKey,
                registerForm,
                isAdvancedQuery,
                querySelectOption,
                objectId,
              } as Recordable,
              {
                ...(slots.toolbar
                  ? {
                      toolbar: () => getSlot(slots, 'toolbar'),
                    }
                  : {}),
                ...(slots.tableTitle
                  ? {
                      tableTitle: () => getSlot(slots, 'tableTitle'),
                    }
                  : {}),
                ...(slots.headerTop
                  ? {
                      headerTop: () => getSlot(slots, 'headerTop'),
                    }
                  : {}),
                ...(slots.headerContent
                  ? {
                      headerContent: () => getSlot(slots, 'headerContent'),
                    }
                  : {}),
                ...formSlots,
              },
            ),
    };
  });

  return { getHeaderProps, getHasHeader };
}
