import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';
import { ErpType } from '/@/enums/erpEnum';
/**
 * @description: 编辑
 */
export async function set(erpType: ErpType, params: any, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: '/system/erp-config',
      params: { erpType, configJson: JSON.stringify(params) },
    },
    {
      errorMessageMode: mode,
    },
  );
}
/**
 * @description: 获取
 */
export async function getInfo(type: ErpType, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<any>(
    {
      url: '/system/erp-config/info-by-type',
      params: { type },
    },
    {
      errorMessageMode: mode,
    },
  );
}
