import { MesProOrderDetailModel, MesProOrderDetailPageParams, MesProOrderDetailPageResult } from './model/ProOrderDetailModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/proorderdetail/page',
  List = '/mes/proorderdetail/list',
  Info = '/mes/proorderdetail/info',
  MesProOrderDetail = '/mes/proorderdetail',
  
  
}

/**
 * @description: 查询MesProOrderDetail分页列表
 */
export async function getMesProOrderDetailPage(params: MesProOrderDetailPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProOrderDetailPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesProOrderDetail信息
 */
export async function getMesProOrderDetail(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesProOrderDetailModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesProOrderDetail
 */
export async function addMesProOrderDetail(mesProOrderDetail: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesProOrderDetail,
      params: mesProOrderDetail,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesProOrderDetail
 */
export async function updateMesProOrderDetail(mesProOrderDetail: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesProOrderDetail,
      params: mesProOrderDetail,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesProOrderDetail（批量删除）
 */
export async function deleteMesProOrderDetail(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesProOrderDetail,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}