import {
  MesQbCheckstandardModel,
  MesQbCheckstandardPageParams,
  MesQbCheckstandardPageResult,
} from './model/MescheckstandardModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/mes/mescheckstandard/page',
  List = '/mes/mescheckstandard/list',
  Info = '/mes/mescheckstandard/info',
  MesQbCheckstandard = '/mes/mescheckstandard',
}

/**
 * @description: 查询MesQbCheckstandard分页列表
 */
export async function getMesQbCheckstandardPage(
  params: MesQbCheckstandardPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<MesQbCheckstandardPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesQbCheckstandard信息
 */
export async function getMesQbCheckstandard(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesQbCheckstandardModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesQbCheckstandard
 */
export async function addMesQbCheckstandard(
  mesQbCheckstandard: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.post<boolean>(
    {
      url: Api.MesQbCheckstandard,
      params: mesQbCheckstandard,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesQbCheckstandard
 */
export async function updateMesQbCheckstandard(
  mesQbCheckstandard: Recordable,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.put<boolean>(
    {
      url: Api.MesQbCheckstandard,
      params: mesQbCheckstandard,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesQbCheckstandard（批量删除）
 */
export async function deleteMesQbCheckstandard(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesQbCheckstandard,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
