import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
enum Api {
  Risk = '/caseErpSupplier/caseErpSupplier/risk',
  Type = '/caseErpSupplier/caseErpSupplier/type',
  History = '/caseErpSupplier/caseErpSupplier/history',
}

/**
 * @description: 查询潜在供应商风险评估统计
 */
export async function getRiskInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Risk,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询供应商类型分布
 */
export async function getTypeInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Type,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询历史价格对比
 */
export async function getHistoryInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.History,
    },
    {
      errorMessageMode: mode,
    },
  );
}
