import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'typeName',
    label: '工序类型',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '状态',
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
    colProps: { span: 8 },
  },

  {
    field: 'remark',
    label: '备注',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'typeName',
    title: '工序类型',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'switch',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: 120,
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '60c0609b08284ee391d87f9d7debd3b0',
      field: 'typeName',
      label: '工序类型',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 255,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入工序类型',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '9a0627b5307444c5875f6bc897beb207',
      field: 'state',
      label: '状态',
      type: 'switch',
      component: 'Switch',
      colProps: { span: 24 },
      defaultValue: 1,
      componentProps: {
        defaultValue: 1,
        unCheckedChildren: '',
        unCheckedColor: '#bbbdbf',
        checkedChildren: '',
        showLabel: true,
        checkedColor: '#5e95ff',
        disabled: false,
        events: {},
        span: '',
        style: {},
      },
    },
    {
      key: 'f24357e4cbcb4ff096a59a1dcba58ccb',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        maxlength: 255,
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '3ef1bb27d2014cad8acf07af0e6307df',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ea59648f7d874a8fbd61a312e596b9a2',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
