import { defHttp } from '/@/utils/http/axios';

import { ErrorMessageMode } from '/#/axios';
enum Api {
  Data = '/caseErpStock/caseErpInstoreLog/sales-statistics',
  Sale = '/caseErpStock/caseErpInstoreLog/proportion-sale',
  Income = '/caseErpStock/caseErpInstoreLog/proportion-income',
  SaleAnalysis = '/caseErpStock/caseErpInstoreLog/sale-analysis',
  ProductAnalysis = '/caseErpStock/caseErpInstoreLog/product-analysis',
  Profit = '/caseErpStock/caseErpInstoreLog/profit-analysis',
}

/**
 * @description: 基础数据
 */
export async function getSaleDataInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Data,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询本月销售占比
 */
export async function getProportionSaleInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Sale,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询销售分析
 */
export async function getSaleAnalysisInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.SaleAnalysis,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询本月收入占比
 */
export async function getProportionIncomeInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Income,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询出库产品分析
 */
export async function getProductAnalysisInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.ProductAnalysis,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 查询本年利润偏差分析
 */
export async function getProfitInfo(mode: ErrorMessageMode = 'modal') {
  return defHttp.get(
    {
      url: Api.Profit,
    },
    {
      errorMessageMode: mode,
    },
  );
}
