import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'rwbh',
    label: '任务编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'jhbh',
    label: '计划编号',
    defaultValue: '',
    component: 'Input',
  },
  {
    field: 'hjzt',
    label: '合金标准',
    defaultValue: '',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/zlgl//zjjcsj/getHjbz',
        method: 'GET',
        apiId: '36768924878d48e5ac3b3b24fc25765e',
        apiParams: [
          { key: '1', title: 'Query Params', tableInfo: [] },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var sql="select id as value,name as label from mes_alloy_standard where delete_mark = 0";\r\nreturn db.select(sql);',
      },
      labelField: 'label',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
  {
    field: 'ywzz',
    label: '业务组织',
    defaultValue: undefined,
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '2015724355955159041' },
      labelField: 'name',
      valueField: 'value',
      mode: 'multiple',
      showSearch: true,
      getPopupContainer: () => document.body,
    },
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'jhbh',
    title: '计划编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'rwbh',
    title: '任务编号',
    componentType: 'auto-code',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'cpid',
    title: '生产产品',
    componentType: 'associate-popup',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'lch',
    title: '炉次号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },


  {
    resizable: true,
    dataIndex: 'jhksrq',
    title: '计划开始时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'jhjsrq',
    title: '计划结束时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
  {
    resizable: true,
    dataIndex: 'ywzz',
    title: '业务组织',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
      isClick: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
      isClick: false,
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
      isClick: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '3e3187de71654c0e9761cc59cbd16b80',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 6,
          list: [
            {
              key: '8c8e1195fac049468aac7e5096b32835',
              field: 'rwbh',
              label: '任务编号',
              type: 'auto-code',
              component: 'AutoCodeRule',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                showLabel: true,
                autoCodeRule: 'SCRW',
                required: true,
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'lkajsldjaljdla',
              field: 'ywzz',
              label: '业务组织',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择下拉选择业务组织',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getCompanyList',
                  method: 'GET',
                  apiId: 'copy1765431632890d13798',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from res_company";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                params: { itemId: '2015724355955159041' },
                itemId: '2015724355955159041',
                style: { width: '100%' },
              },
            },




           /* {
              key: 'b22f0a133613428f84ee08c70c61311b',
              field: 'zch',
              label: '铸次号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: { change: '' },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },*/
            {
              key: '25e30bcce47a437fb5674d9dbce3523a',
              field: 'zl',
              label: '重量/KG',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                step: 0.1,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: { change: '' },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'd66e5ebfa5d64b829fde596c82155158',
              field: 'sfnbdd',
              label: '是否内部订单',
              type: 'radio',
              component: 'ApiRadioGroup',
              colProps: { span: 24 },
              componentProps: {
                span: 7,
                showLabel: true,
                disabled: false,
                optionType: 'default',
                staticOptions: [
                  { key: 2, label: '是', value: '1' },
                  { key: 3, label: '否', value: '2' },
                ],
                datasourceType: 'staticData',
                labelField: 'label',
                valueField: 'value',
                defaultSelect: '2',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: { change: '' },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'd27a9e1461404e13bfa27c0e8b5b94a8',
              field: 'jhbh',
              label: '计划编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '207f6fc4afc94690a5e197c9cc3848bc',
              field: 'hjzt',
              label: '合金标准',
              type: 'associate-select',
              component: 'AssociateSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/zlgl//zjjcsj/getHjbz',
                  method: 'GET',
                  apiId: '36768924878d48e5ac3b3b24fc25765e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from mes_alloy_standard where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '8970047af14d421897b19c5dbd0cb216',
              field: 'zxbz',
              label: '执行标准',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: { change: '' },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '427fc55accd744d0a6359faf80e45a1b',
              field: 'sccx',
              label: '产线',
              type: 'associate-select',
              component: 'AssociateSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getCxByCjbh',
                  method: 'GET',
                  apiId: 'ecbc0291292c49fca50468561b9770e8',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'cjid',
                          value:
                            '{"bindField":"sccj","fieldKey":"21610208f2b8428e84de66979709d296"}',
                          required: true,
                          defaultValue: '0',
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql='select cx.*,cx.id as value,cx.cxmc as label from mes_base_chanxian cx join mes_base_cj_cx rela on cx.id=rela.cxid where rela.delete_mark=0 and cx.delete_mark=0 and rela.cjid=#{cjid}'\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: { change: '' },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'eb29665fc1e3453d9ef8aa88f8dfac0c',
              field: 'zzl',
              label: '铸造量',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: { change: '' },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '99da98d5a335454a9d613715e539c7bd',
              field: 'kh',
              label: '客户',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx/getKhList',
                  method: 'GET',
                  apiId: '7bc8db3faba24b19a997856f6ef0b27e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from roke_partner where delete_mark = 0 and customer = \'1\'";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'c522ec15933c4d448a448e4d67897aa0',
              field: 'jhksrq',
              label: '计划开始时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              componentProps: {
                span: 7,
                width: '100%',
                placeholder: '请选择',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: { change: '' },
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
            {
              key: '21610208f2b8428e84de66979709d296',
              field: 'sccj',
              label: '车间',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getAllChejian',
                  method: 'GET',
                  apiId: '59730efb7b4a4439a013cac04926e00e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql='select *,id as value,cjmc as label from mes_base_chejian where delete_mark=0'\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: { change: '' },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'fsdfsdf',
              field: 'lch',
              label: '炉次号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: { change: '' },
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'a5e642899c704810897d4d25a7604b4f',
              field: 'jz',
              label: '均质',
              type: 'radio',
              component: 'ApiRadioGroup',
              colProps: { span: 24 },
              componentProps: {
                span: 7,
                showLabel: true,
                disabled: false,
                optionType: 'default',
                staticOptions: [
                  { key: 2, label: '是', value: '1' },
                  { key: 3, label: '否', value: '2' },
                ],
                datasourceType: 'staticData',
                labelField: 'label',
                valueField: 'value',
                defaultSelect: '1',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: {},
              },
            },
            {
              key: 'dbff4c30b51e45a0abda869b986c2af2',
              field: 'jhjsrq',
              label: '计划结束时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: { change: '' },
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
            {
              key: 'fd52ee27396a4a028c80e1f6b883efaf',
              field: 'sl',
              label: '数量',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                step: 0.1,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: { change: '' },
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [

          ],
        },
      ],
      componentProps: {
        gutter: 0,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '0c86713315c948d69dde675c2b7dc8cf',
      field: '',
      label: '分割线',
      colProps: { span: 24 },
      type: 'divider',
      component: 'Divider',
      componentProps: {
        dashed: false,
        orientation: 'left',
        text: '',
        isShow: true,
        style: { marginTop: '0px', marginBottom: '0px' },
      },
    },
    {
      key: 'fa2613d0ce99458ea793159a6548621d',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 6,
          list: [
            {
              key: 'c1164302d0e34bca96563db3f47700f6',
              field: 'cpid',
              label: '生产产品',
              type: 'associate-popup',
              component: 'MultiplePopup',
              colProps: { span: 24 },
              componentProps: {
                popupType: 'associate',
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                pageSize: 10,
                assoTitle: '选择产品',
                apiConfig: {
                  path: '/scgl/scjh/getAllProduct',
                  method: 'GET',
                  apiId: 'f4fbb57f2f18425e97918a031c8aa7d8',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,cpmc as label from mes_base_product_info where delete_mark=0';\r\nreturn db.select(sql)",
                  outputParams: [
                    { name: 'cpmc', tableTitle: '产品名称', show: true, width: 150 },
                    {
                      name: 'cplx',
                      tableTitle: '产品类别',
                      bindField: 'cplx',
                      show: true,
                      width: 150,
                      component: 'a954da9a8da9429895b9ca947b937c92',
                    },
                    {
                      name: 'gg',
                      tableTitle: '规格',
                      bindField: 'gg',
                      show: true,
                      width: 150,
                      component: '6baebd752fae4267aa0ce0a684aa3a1c',
                    },
                  ],
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: { change: '' },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: 'a954da9a8da9429895b9ca947b937c92',
              field: 'cplx',
              label: '产品类别',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '自动带入',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: true,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'dic',
                params: { itemId: '2003761375221407745' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: 'CodeGeneration/selection',
                  method: 'GET',
                  apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2003761375221407745',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '6baebd752fae4267aa0ce0a684aa3a1c',
              field: 'gg',
              label: '规格',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '自动带入',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },

      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '220d208f92b543189c73f3f1caeb660e',
      field: '',
      label: '分割线',
      colProps: { span: 24 },
      type: 'divider',
      component: 'Divider',
      componentProps: {
        dashed: false,
        orientation: 'left',
        text: '',
        isShow: true,
        style: { marginTop: '0px', marginBottom: '0px' },
      },
    },
    {
      key: '4db1fb6401f7456b89ae8223d3acb883',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 6,
          list: [
            {
              key: '90df3bd996a3469789d4557edf80aca7',
              field: 'gylx',
              label: '工艺路线',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getAllgylx',
                  method: 'GET',
                  apiId: '07d17a5272a746c5b8711e8820440c65',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,name as label from roke_routing where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: { change: '' },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 6,
          list: [
            {
              key: '393152195470452c989d23033a75e13b',
              field: 'bom',
              label: 'BOM',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/wlqd/getAllBomItemZd',
                  method: 'GET',
                  apiId: 'copy1767851514693d23060',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,bommc as label from mes_base_bom where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: { change: 'curRowData.mesProductionGongdanList={}' },
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        { span: 6,
          list: [
            {
              key: 'fsfsdfsdfsfa',
              field: 'yxj',
              label: '优先级',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: null,
                datasourceType: 'dic',
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: '/bmxx/getCompanyList',
                  method: 'GET',
                  apiId: 'copy1765431632890d13798',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select id as value,name as label from res_company";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: true,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                params: { itemId: '2013507407135862785' },
                itemId: '2013507407135862785',
                style: { width: '100%' },
              },
            },
          ]
        },
        { span: 6, list: [] },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: 'be5dd9f33feb447c83f8313511feab47',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '工单',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '29977890304c441bae527eba5f019e46',
              label: '',
              field: 'mesProductionGongdanList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesProductionGongdanList',
                columns: [
                  // {
                  //   key: '2745856f030c4f4b8488732136060d78',
                  //   title: '任务编号',
                  //   dataIndex: 'rwbh',
                  //   componentType: 'Input',
                  //   defaultValue: '',
                  //   componentProps: {
                  //     width: '100%',
                  //     span: '',
                  //     defaultValue: '',
                  //     placeholder: '请输入任务编号任务编号任务编号',
                  //     prefix: '',
                  //     suffix: '',
                  //     addonBefore: '',
                  //     addonAfter: '',
                  //     disabled: false,
                  //     allowClear: false,
                  //     showLabel: true,
                  //     required: false,
                  //     rules: [],
                  //     events: {},
                  //     listStyle: '',
                  //     isSave: false,
                  //     isShow: true,
                  //     scan: false,
                  //     bordered: true,
                  //     isShowAi: false,
                  //     tooltipConfig: { visible: false, title: '提示文本' },
                  //   },
                  // },
                  // {
                  //   key: 'e2a2a9437363423b93f280617e27d8d2',
                  //   title: '计划编号',
                  //   dataIndex: 'jhbh',
                  //   componentType: 'Input',
                  //   defaultValue: '',
                  //   componentProps: {
                  //     width: '100%',
                  //     span: '',
                  //     defaultValue: '',
                  //     placeholder: '请输入计划编号',
                  //     prefix: '',
                  //     suffix: '',
                  //     addonBefore: '',
                  //     addonAfter: '',
                  //     disabled: false,
                  //     allowClear: false,
                  //     showLabel: true,
                  //     required: false,
                  //     rules: [],
                  //     events: {},
                  //     listStyle: '',
                  //     isSave: false,
                  //     isShow: true,
                  //     scan: false,
                  //     bordered: true,
                  //     isShowAi: false,
                  //     tooltipConfig: { visible: false, title: '提示文本' },
                  //   },
                  // },
                  // {
                  //   key: '589c359e5a7e498695fcf5c224a5e557',
                  //   title: '熔次号',
                  //   dataIndex: 'rch',
                  //   componentType: 'Input',
                  //   defaultValue: '',
                  //   componentProps: {
                  //     width: '100%',
                  //     span: '',
                  //     defaultValue: '',
                  //     placeholder: '请输入熔次号',
                  //     prefix: '',
                  //     suffix: '',
                  //     addonBefore: '',
                  //     addonAfter: '',
                  //     disabled: false,
                  //     allowClear: false,
                  //     showLabel: true,
                  //     required: false,
                  //     rules: [],
                  //     events: {},
                  //     listStyle: '',
                  //     isSave: false,
                  //     isShow: true,
                  //     scan: false,
                  //     bordered: true,
                  //     isShowAi: false,
                  //     tooltipConfig: { visible: false, title: '提示文本' },
                  //   },
                  // },
                  // {
                  //   key: '2957c762b0a3437f872fdab6f46544c2',
                  //   title: '铸次号',
                  //   dataIndex: 'zch',
                  //   componentType: 'Input',
                  //   defaultValue: '',
                  //   componentProps: {
                  //     width: '100%',
                  //     span: '',
                  //     defaultValue: '',
                  //     placeholder: '请输入铸次号单行文本',
                  //     prefix: '',
                  //     suffix: '',
                  //     addonBefore: '',
                  //     addonAfter: '',
                  //     disabled: false,
                  //     allowClear: false,
                  //     showLabel: true,
                  //     required: false,
                  //     rules: [],
                  //     events: {},
                  //     listStyle: '',
                  //     isSave: false,
                  //     isShow: true,
                  //     scan: false,
                  //     bordered: true,
                  //     isShowAi: false,
                  //     tooltipConfig: { visible: false, title: '提示文本' },
                  //   },
                  // },
                  // {
                  //   key: 'c1ed5718a38d45d298352ea8b22eb2b8',
                  //   title: '合金标准',
                  //   dataIndex: 'hjzt',
                  //   componentType: 'XjrSelect',
                  //   componentProps: {
                  //     width: '100%',
                  //     span: '',
                  //     placeholder: '请选择下拉选择',
                  //     showLabel: true,
                  //     showSearch: false,
                  //     isMultiple: false,
                  //     clearable: false,
                  //     disabled: false,
                  //     staticOptions: [
                  //       { key: 1, label: 'Option 1', value: 'Option 1' },
                  //       { key: 2, label: 'Option 2', value: 'Option 2' },
                  //       { key: 3, label: 'Option 3', value: 'Option 3' },
                  //     ],
                  //     defaultSelect: '',
                  //     datasourceType: 'api',
                  //     labelField: 'label',
                  //     valueField: 'value',
                  //     apiConfig: {
                  //       path: '/zlgl//zjjcsj/getHjbz',
                  //       method: 'GET',
                  //       apiId: '36768924878d48e5ac3b3b24fc25765e',
                  //       apiParams: [
                  //         { key: '1', title: 'Query Params', tableInfo: [] },
                  //         { key: '2', title: 'Header', tableInfo: [] },
                  //         { key: '3', title: 'Body' },
                  //       ],
                  //       script:
                  //         'var sql="select id as value,name as label from mes_alloy_standard where delete_mark = 0";\r\nreturn db.select(sql);',
                  //     },
                  //     dicOptions: [],
                  //     required: false,
                  //     rules: [],
                  //     events: {},
                  //     isShow: true,
                  //     tooltipConfig: { visible: false, title: '提示文本' },
                  //     listStyle: "return 'border: 0'",
                  //   },
                  // },
                  // {
                  //   key: '69da890610284539b4ad26bed8e9c566',
                  //   title: '产品ID',
                  //   dataIndex: 'cpid',
                  //   componentType: 'Input',
                  //   defaultValue: '',
                  //   componentProps: {
                  //     width: '100%',
                  //     span: '',
                  //     defaultValue: '',
                  //     placeholder: '请输入产品ID',
                  //     prefix: '',
                  //     suffix: '',
                  //     addonBefore: '',
                  //     addonAfter: '',
                  //     disabled: false,
                  //     allowClear: false,
                  //     showLabel: true,
                  //     required: false,
                  //     rules: [],
                  //     events: {},
                  //     listStyle: '',
                  //     isSave: false,
                  //     isShow: false,
                  //     scan: false,
                  //     bordered: true,
                  //     isShowAi: false,
                  //     tooltipConfig: { visible: false, title: '提示文本' },
                  //   },
                  // },
                  // {
                  //   key: 'dc242ae845f1489a8cc2f47c98b565b8',
                  //   title: '产品类型',
                  //   dataIndex: 'cplx',
                  //   componentType: 'XjrSelect',
                  //   componentProps: {
                  //     width: '100%',
                  //     span: '',
                  //     placeholder: '请选择下拉选择',
                  //     showLabel: true,
                  //     showSearch: false,
                  //     isMultiple: false,
                  //     clearable: false,
                  //     disabled: false,
                  //     staticOptions: [
                  //       { key: 1, label: 'Option 1', value: 'Option 1' },
                  //       { key: 2, label: 'Option 2', value: 'Option 2' },
                  //       { key: 3, label: 'Option 3', value: 'Option 3' },
                  //     ],
                  //     datasourceType: 'dic',
                  //     params: { itemId: '2003761375221407745' },
                  //     labelField: 'name',
                  //     valueField: 'value',
                  //     apiConfig: {
                  //       path: 'CodeGeneration/selection',
                  //       method: 'GET',
                  //       apiId: '93d735dcb7364a0f8102188ec4d77ac7',
                  //     },
                  //     dicOptions: [],
                  //     required: false,
                  //     rules: [],
                  //     events: {},
                  //     isShow: true,
                  //     tooltipConfig: { visible: false, title: '提示文本' },
                  //     itemId: '2003761375221407745',
                  //     defaultSelect: '',
                  //     listStyle: "return 'border: 0'",
                  //   },
                  // },
                  // {
                  //   key: '7e31a788100b4eefba52c3a36443ba87',
                  //   title: '客户',
                  //   dataIndex: 'kh',
                  //   componentType: 'XjrSelect',
                  //   componentProps: {
                  //     width: '100%',
                  //     placeholder: '请选择客户',
                  //     showLabel: true,
                  //     showSearch: false,
                  //     isMultiple: false,
                  //     clearable: false,
                  //     disabled: false,
                  //     staticOptions: [
                  //       { key: 1, label: 'Option 1', value: 'Option 1' },
                  //       { key: 2, label: 'Option 2', value: 'Option 2' },
                  //       { key: 3, label: 'Option 3', value: 'Option 3' },
                  //     ],
                  //     defaultSelect: '',
                  //     datasourceType: 'api',
                  //     labelField: 'label',
                  //     valueField: 'value',
                  //     apiConfig: {
                  //       path: '/jcxx/getKhList',
                  //       method: 'GET',
                  //       apiId: '7bc8db3faba24b19a997856f6ef0b27e',
                  //       apiParams: [
                  //         { key: '1', title: 'Query Params', tableInfo: [] },
                  //         { key: '2', title: 'Header', tableInfo: [] },
                  //         { key: '3', title: 'Body' },
                  //       ],
                  //       script:
                  //         'var sql="select id as value,name as label from roke_partner where delete_mark = 0 and customer = \'1\'";\r\nreturn db.select(sql);',
                  //     },
                  //     dicOptions: [],
                  //     required: false,
                  //     rules: [],
                  //     events: {},
                  //     isShow: true,
                  //     tooltipConfig: { visible: false, title: '提示文本' },
                  //     listStyle: "return 'border: 0'",
                  //   },
                  // },
                  {
                    key: '16fd1699db7744379edd01b6eb5653f9',
                    title: '工序编号',
                    dataIndex: 'gxbh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: '',
                    },
                  },
                  {
                    key: '570d856e58c447a098efc1be72a545ea',
                    title: '工序名称',
                    dataIndex: 'gxmc',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: '',
                    },
                  },
                  {
                    key: '2f069a67fe784742a2729fa09af94ec4',
                    title: '工序ID隐藏',
                    dataIndex: 'gxId',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '请输入工序ID隐藏单行文本',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      prestrainField: '',
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: { load: '' },
                showPagenation: true,
              },
            },
          ],
        },
        {
          span: 24,
          name: '物料清单',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '4e386be4299d40a8a3d6ac92cb5f8225',
              label: '',
              field: 'mesWarehouseMaterialList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesWarehouseMaterialList',
                columns: [
                  {
                    key: '0318bdc0f00a4dfc9d5a75230e9a07c4',
                    title: '物料编号',
                    dataIndex: 'wlbh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'baa1ec42588e4bfa88c0e22cac084193',
                    title: '物料名称',
                    dataIndex: 'wlmc',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '1da4e46715f0411e951807ff6179820e',
                    title: '下级BOM',
                    dataIndex: 'xjbom',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '599d78bdf5794a30a0637213c5e7d05d',
                    title: '数量',
                    dataIndex: 'blsl',
                    componentType: 'InputNumber',
                    componentProps: {
                      width: '100%',
                      span: '',
                      step: 1,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: true,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '095881c6083d44f28854716c13386f8f',
                    title: '库存量',
                    dataIndex: 'kcl',
                    componentType: 'InputNumber',
                    componentProps: {
                      width: '100%',
                      span: '',
                      step: 1,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '2e2b5dec301f45d99ca29ab90590223b',
                    title: '客户标准(%)',
                    dataIndex: 'khbz',
                    componentType: 'InputNumber',
                    componentProps: {
                      width: '100%',
                      span: '',
                      step: 0.01,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: '5e1c4fee76c14596a870f161fefed804',
                    title: '内控标准(%)',
                    dataIndex: 'nkbz',
                    componentType: 'InputNumber',
                    componentProps: {
                      width: '100%',
                      span: '',
                      step: 0.01,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'a1d690dc949645669e361c706807680b',
                    title: '是否投料',
                    dataIndex: 'sftl',
                    componentType: 'Switch',
                    defaultValue: 1,
                    componentProps: {
                      span: '',
                      defaultValue: 1,
                      checkedChildren: '',
                      unCheckedChildren: '',
                      checkedColor: '#1C8DFF',
                      unCheckedColor: '#bbbdbf',
                      showLabel: true,
                      disabled: false,
                      events: {},
                      isShow: true,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'e7bb2cd58fb24bf487991d757dcae65b',
                    title: '物料ID隐藏',
                    dataIndex: 'wlId',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: false,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'static',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: false,
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
