
import { MesWarehouseProductPageModel, MesWarehouseProductPageParams, MesWarehouseProductPageResult } from './model/ScrkModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/ckgl/scrk/page',
  List = '/ckgl/scrk/list',
  Info = '/ckgl/scrk/info',
  MesWarehouseProduct = '/ckgl/scrk',
  
  
  
}

/**
 * @description: 查询MesWarehouseProduct分页列表
 */
export async function getMesWarehouseProductPage(params: MesWarehouseProductPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseProductPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesWarehouseProduct信息
 */
export async function getMesWarehouseProduct(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesWarehouseProductPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesWarehouseProduct
 */
export async function addMesWarehouseProduct(mesWarehouseProduct: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesWarehouseProduct,
      params: mesWarehouseProduct,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesWarehouseProduct
 */
export async function updateMesWarehouseProduct(mesWarehouseProduct: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesWarehouseProduct,
      params: mesWarehouseProduct,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesWarehouseProduct（批量删除）
 */
export async function deleteMesWarehouseProduct(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesWarehouseProduct,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




