import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'bh',
    label: '记录编号',
    defaultValue: undefined,
    component: 'Input',
  },
  {
    field: 'zxbz',
    label: '执行标准',
    defaultValue: undefined,
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    resizable: true,
    dataIndex: 'bh',
    title: '记录编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cpbh',
    title: '产品编号',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'zxbz',
    title: '执行标准',
    componentType: 'input',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: '',
  },

  {
    resizable: true,
    dataIndex: 'cpid',
    title: '产品名称',
    componentType: 'select',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'bgr',
    title: '报工人',
    componentType: 'user',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'zyr',
    title: '作业人',
    componentType: 'user',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'kssj',
    title: '计划开始时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },

  {
    resizable: true,
    dataIndex: 'jssj',
    title: '计划结束时间',
    componentType: 'date',

    fixed: false,
    sorter: true,

    styleConfig: undefined,
    listStyle: undefined,
  },
];
//表头合并配置
export const headerMergingData = [];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'f1c029ad704b4054b1e91d6a2f423b03',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 8,
          list: [
            {
              key: 'df5c1685093f448bb7314bd319a76c22',
              field: 'bh',
              label: '记录编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '543f2a341e2e47c5b7728aa9f64e5b61',
              field: 'zxbz',
              label: '执行标准',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入执行标准',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '07145a88be434a6b94850f07a17ff369',
              field: 'cpbh',
              label: '产品编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'edcec677be334cd98a30ffb49501d2e1',
              field: 'cpid',
              label: '产品名称',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx/getProduct',
                  method: 'GET',
                  apiId: 'copy1767517099244d66500',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as value,cpmc as label from mes_base_product_info where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2003761375221407745',
                style: { width: '100%' },
              },
            },
            {
              key: 'd0c90eff4a8d4484afcfd4d8501c8e4b',
              field: 'hj',
              label: '合金标准',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [{ key: 1, label: '标准1', value: '标准1' }],
                defaultSelect: '',
                datasourceType: 'staticData',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getAllChejian',
                  method: 'GET',
                  apiId: '59730efb7b4a4439a013cac04926e00e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql='select *,id as value,cjmc as label from mes_base_chejian where delete_mark=0'\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '0b571887e8864132b5287306f1b4c5a8',
              field: 'cplb',
              label: '产品类型',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'dic',
                params: { itemId: '2003761375221407745' },
                labelField: 'name',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scjh/getAllProduct',
                  method: 'GET',
                  apiId: 'f4fbb57f2f18425e97918a031c8aa7d8',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,cpmc as label from mes_base_product_info where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2003761375221407745',
                style: { width: '100%' },
              },
            },
            {
              key: 'd08395996c654ea88ff28ca32ba63cc1',
              field: 'bgr',
              label: '报工人',
              type: 'user',
              component: 'User',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                width: '100%',
                defaultValue: '',
                placeholder: '',
                userType: 0,
                prefix: '',
                suffix: 'ant-design:user-outlined',
                showLabel: true,
                disabled: false,
                required: false,
                multiple: false,
                isShow: true,
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '241eb88734074a9fa8a8ad1a52250b2c',
              field: 'zyr',
              label: '作业人',
              type: 'user',
              component: 'User',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                width: '100%',
                defaultValue: '',
                placeholder: '',
                userType: 0,
                prefix: '',
                suffix: 'ant-design:user-outlined',
                showLabel: true,
                disabled: false,
                required: false,
                multiple: false,
                isShow: true,
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '067a782909fe43aca1f96fe9bf0e9f31',
              field: 'bgzz',
              label: '报工班组',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [{ key: 1, label: '1组', value: '1组' }],
                datasourceType: 'staticData',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scjh/getAllProduct',
                  method: 'GET',
                  apiId: 'f4fbb57f2f18425e97918a031c8aa7d8',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,cpmc as label from mes_base_product_info where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2003761375221407745',
                defaultSelect: '',
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'e439465000834adeb3e48c8cacb93715',
              field: 'gdbh',
              label: '工单编号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: true,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '129f257640b143578df327739109cd98',
              field: 'sccj',
              label: '生产车间',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                defaultSelect: '',
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getAllChejian',
                  method: 'GET',
                  apiId: '59730efb7b4a4439a013cac04926e00e',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql='select *,id as value,cjmc as label from mes_base_chejian where delete_mark=0'\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'a8a4a06e96964f2a9d7ea44f1ecc0feb',
              field: 'sccx',
              label: '生产产线',
              type: 'associate-select',
              component: 'AssociateSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                disabled: false,
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/scgl/scrw/getCxByCjbh',
                  method: 'GET',
                  apiId: 'ecbc0291292c49fca50468561b9770e8',
                  apiParams: [
                    {
                      key: '1',
                      title: 'Query Params',
                      tableInfo: [
                        {
                          name: 'cjid',
                          value:
                            '{"bindField":"sccj","fieldKey":"129f257640b143578df327739109cd98"}',
                          required: true,
                          dataType: 'String',
                          defaultValue: '0',
                          bindType: 'data',
                        },
                      ],
                    },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql='select cx.*,cx.id as value,cx.cxmc as label from mes_base_chanxian cx join mes_base_cj_cx rela on cx.id=rela.cxid where rela.delete_mark=0 and cx.delete_mark=0 and rela.cjid=#{cjid}'\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '9c0fa9d61565467b99cdc62892bda01a',
              field: 'gzzx',
              label: '工作中心',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx//cjcx/getAllGzzx',
                  method: 'GET',
                  apiId: 'cf582f4ea9814b769291c318c35cbb96',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    "var sql = 'select *,id as value,gzzxmc as label from mes_base_gzzx where delete_mark=0';\r\nreturn db.select(sql)",
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'e8cd7b3390074ec5b4367e1ceb30d78d',
              field: 'gxId',
              label: '工序',
              type: 'select',
              component: 'XjrSelect',
              colProps: { span: 24 },
              componentProps: {
                width: '100%',
                span: 7,
                placeholder: '请选择',
                showLabel: true,
                showSearch: false,
                isMultiple: false,
                clearable: false,
                disabled: false,
                staticOptions: [
                  { key: 1, label: 'Option 1', value: 'Option 1' },
                  { key: 2, label: 'Option 2', value: 'Option 2' },
                  { key: 3, label: 'Option 3', value: 'Option 3' },
                ],
                datasourceType: 'api',
                labelField: 'label',
                valueField: 'value',
                apiConfig: {
                  path: '/jcxx/gxlb',
                  method: 'GET',
                  apiId: '8a735bb14d5f4a709efb65b34691acd3',
                  apiParams: [
                    { key: '1', title: 'Query Params', tableInfo: [] },
                    { key: '2', title: 'Header', tableInfo: [] },
                    { key: '3', title: 'Body' },
                  ],
                  script:
                    'var sql="select *,id as value,name as label from roke_process where delete_mark = 0";\r\nreturn db.select(sql);',
                },
                dicOptions: [],
                required: false,
                rules: [],
                events: {},
                isShow: true,
                tooltipConfig: { visible: false, title: '提示文本' },
                itemId: '2003761375221407745',
                style: { width: '100%' },
              },
            },
            {
              key: '545181bca5f94cdcac9051a9ed30c368',
              field: 'bgsj',
              label: '报工时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择报工时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
            {
              key: '097b043cc4e54622b3023e5344508276',
              field: 'gs',
              label: '工时',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                step: 0.01,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: '2ffb3db0cb0d42df9e7ff6f5dc63fbc6',
              field: 'hgs',
              label: '合格数',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                step: 0.01,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 8,
          list: [
            {
              key: 'fada4c1222a94076a8e811c6489ce593',
              field: 'zch',
              label: '铸次号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入铸次号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'ea69ce78a15d42099050b621186fd831',
              field: 'rzl',
              label: '铸造量',
              type: 'number',
              component: 'InputNumber',
              colProps: { span: 24 },
              defaultValue: 0,
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: 0,
                min: 0,
                step: 0.01,
                disabled: false,
                showLabel: true,
                controls: true,
                required: false,
                subTotal: false,
                isShow: true,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'dca82bcd3e7b44dfa96df1bc5a8d3ff3',
              field: 'rch',
              label: '熔次号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入熔次号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                bordered: true,
                isShowAi: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
            {
              key: 'dc5d1cdc42b34094a3d6af5ee787e0df',
              field: 'kssj',
              label: '计划开始时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择计划开始时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
            {
              key: '18a845043f1a44e4952c7255fb352aa5',
              field: 'jssj',
              label: '计划结束时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择计划结束时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                isGetCurrent: false,
                tooltipConfig: { visible: false, title: '提示文本' },
                searchType: 'time',
                style: { width: '100%' },
              },
            },
            {
              key: 'd01e9984dad44089b367e932f00cbd7f',
              field: 'bz',
              label: '备注',
              type: 'textarea',
              component: 'InputTextArea',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入备注',
                rows: 4,
                autoSize: false,
                showCount: false,
                disabled: false,
                showLabel: true,
                allowClear: false,
                required: false,
                isShow: true,
                isShowAi: false,
                rules: [],
                events: {},
                tooltipConfig: { visible: false, title: '提示文本' },
                style: { width: '100%' },
              },
            },
          ],
        },
      ],
      componentProps: {
        gutter: 16,
        justify: 'start',
        align: 'top',
        isShow: true,
        showBorder: false,
        bordercolor: '#d9d9d9',
        bordershowtype: [true, true, true, true],
        borderwidth: 1,
        padding: '10px',
        margin: '10px',
      },
    },
    {
      key: '5ddb609cd16c4f06a850181c1174b0d5',
      field: '',
      label: '',
      type: 'tab',
      colProps: { span: 24 },
      component: 'Tab',
      children: [
        {
          span: 24,
          name: '数据采集详情',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '6858fe13441243c790a63bf5b974435b',
              label: '',
              field: 'mesGongdanDataCollectionList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesGongdanDataCollectionList',
                columns: [
                  {
                    key: '89af383317a948508759eadd9d48adb6',
                    title: '采集项',
                    dataIndex: 'cjx',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'b17eaa6f85024c26b22c9551354e3c5a',
                    title: '采集值',
                    dataIndex: 'cjz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '63ab9a80ee1945399e73dd9310e91aa8',
                    title: '标准值',
                    dataIndex: 'bzz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '553e79c992b74ecb91c3bf3ccd2af87c',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
        {
          span: 24,
          name: '质检信息',
          prefix: '',
          suffix: '',
          activeColor: '#1c8dff',
          folderId: '',
          imageUrl: '',
          conFolderId: '',
          conImageUrl: '',
          list: [
            {
              key: '24408a8dcca1423789dcdeff031e4d9f',
              label: '',
              field: 'mesGongdanQualityInspectionList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesGongdanQualityInspectionList',
                columns: [
                  {
                    key: '62f5f554a68244f5b721f73d4c68988e',
                    title: '质检单号',
                    dataIndex: 'zjdh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '19ec9fc3d6394fcab8b472d857a4f31b',
                    title: '质检结果',
                    dataIndex: 'zjjg',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'e6d92e00e9da4bb59ca4e664119ae183',
                    title: '质检员',
                    dataIndex: 'jyy',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'c6d641ee7dfc4336ae157553c1a4e4e9',
                    title: '质检信息',
                    dataIndex: 'zjsj',
                    componentType: 'DatePicker',
                    defaultValue: '',
                    componentProps: {
                      span: '',
                      defaultValue: '',
                      width: '100%',
                      placeholder: '',
                      format: 'YYYY-MM-DD HH:mm:ss',
                      showLabel: true,
                      allowClear: true,
                      disabled: false,
                      required: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      isGetCurrent: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                      searchType: 'time',
                    },
                  },
                  {
                    key: '3b9215b704c74d9bad707adf6c04f50f',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
        {
          span: 0,
          name: '投料信息',
          list: [
            {
              key: '3de87256379c41d18252370cb451630f',
              label: '',
              field: 'mesGongdanMaterialFeedingList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesGongdanMaterialFeedingList',
                columns: [
                  {
                    key: 'd9196faf398347cd958ec21de698e780',
                    title: '物料编号',
                    dataIndex: 'wlbh',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'f255a9b82d6646d6ac6750c9fbf87329',
                    title: '物料名称',
                    dataIndex: 'wlmc',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '43490105227045229f2f1816f6ff8474',
                    title: '数量',
                    dataIndex: 'tlsl',
                    componentType: 'InputNumber',
                    defaultValue: 0,
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: 0,
                      min: 0,
                      step: 0.01,
                      disabled: false,
                      showLabel: true,
                      controls: true,
                      required: false,
                      subTotal: false,
                      isShow: true,
                      rules: [],
                      events: {},
                      tooltipConfig: { visible: false, title: '提示文本' },
                      listStyle: "return 'width:100%'",
                    },
                  },
                  {
                    key: 'c9f4ec8bb7a944d19f1e6ce4582c3509',
                    title: '投料人',
                    dataIndex: 'tlr',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '57d915aeb50f490cbe2970a29921989b',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
        {
          span: 0,
          name: '生产采集信息',
          list: [
            {
              key: 'c9e3e41674b841a285aca529b7ef8a64',
              label: '',
              field: 'mesGongdanScCollectionList',
              type: 'form',
              component: 'SubForm',
              required: true,
              colProps: { span: 24 },
              componentProps: {
                mainKey: 'mesGongdanScCollectionList',
                columns: [
                  {
                    key: '5e21bdbe50864ceba2f6e4a54f497427',
                    title: '采集项',
                    dataIndex: 'cjx',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: 'ee243d18029947e19f527e1b38417d3b',
                    title: '采集值',
                    dataIndex: 'cjz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                  {
                    key: '4d07e4bfe0224ba2ac17464973bc42dc',
                    title: '备注',
                    dataIndex: 'bz',
                    componentType: 'Input',
                    defaultValue: '',
                    componentProps: {
                      width: '100%',
                      span: '',
                      defaultValue: '',
                      placeholder: '',
                      prefix: '',
                      suffix: '',
                      addonBefore: '',
                      addonAfter: '',
                      disabled: false,
                      allowClear: false,
                      showLabel: true,
                      required: false,
                      rules: [],
                      events: {},
                      listStyle: '',
                      isSave: false,
                      isShow: true,
                      scan: false,
                      bordered: true,
                      isShowAi: false,
                      tooltipConfig: { visible: false, title: '提示文本' },
                    },
                  },
                ],
                span: '24',
                preloadType: 'api',
                apiConfig: {},
                itemId: '',
                dicOptions: [],
                useSelectButton: false,
                buttonName: '选择数据',
                showLabel: true,
                showComponentBorder: true,
                showBorder: false,
                bordercolor: '#f0f0f0',
                bordershowtype: [true, true, true, true],
                borderwidth: 1,
                showIndex: true,
                isShow: true,
                multipleHeads: [],
                buttonList: [],
                topButtonList: [],
                isExport: false,
                isImport: false,
                isDeleteSelected: false,
                isListView: false,
                viewList: [],
                isShowAdd: false,
                isShowDelete: false,
                hasCheckedCol: false,
                events: {},
                showPagenation: true,
              },
            },
          ],
        },
      ],
      componentProps: { tabPosition: 'top', size: 'default', type: 'line', isShow: true },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
