import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'dataCode',
    label: '申请单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'dataName',
    label: '申请主题',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'dataDate',
    label: '调拨日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'dataUnit',
    label: '申请部门',
    component: 'Dept',
    componentProps: {
      placeholder: '请选择',
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'dataUser',
    label: '申请人员',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'dataPhone',
    label: '联系电话',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'inStorage',
    label: '调入仓库',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
        apiParams: [
          {
            tableInfo: [
              { bindType: 'value', required: false, name: 'data_type', value: '0' },
              {
                dataType: 'String',
                bindType: '',
                required: false,
                name: 'warehouse_id',
                value: '',
              },
              { dataType: 'String', bindType: '', required: false, name: 'area_id', value: '' },
              { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
            ],
            title: 'Query Params',
            key: '1',
          },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getWarehouseList',
        apiId: 'd5acd359b8c6490caa8291712d2a2127',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'outStorage',
    label: '调出仓库',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
        apiParams: [
          {
            tableInfo: [
              { bindType: 'value', required: false, name: 'data_type', value: '0' },
              {
                dataType: 'String',
                bindType: '',
                required: false,
                name: 'warehouse_id',
                value: '',
              },
              { dataType: 'String', bindType: '', required: false, name: 'area_id', value: '' },
              { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
            ],
            title: 'Query Params',
            key: '1',
          },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getWarehouseList',
        apiId: 'd5acd359b8c6490caa8291712d2a2127',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'dataCode',
    title: '申请单号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'dataName',
    title: '申请主题',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'dataDate',
    title: '调拨日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'dataUnit',
    title: '申请部门',
    componentType: 'organization',

    sorter: true,
  },

  {
    dataIndex: 'dataUser',
    title: '申请人员',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'dataPhone',
    title: '联系电话',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'inStorage',
    title: '调入仓库',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'outStorage',
    title: '调出仓库',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'products',
    title: '物品摘要',
    componentType: 'input',
    sorter: true,
    align: 'right',
  },
  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'aaa702bb9c6c43e9bcdf59948bdaf060',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '基础信息',
      componentProps: {
        color: '',
        defaultValue: '基础信息',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'c317aad036c8422ba088fee9b2c6e93e',
      field: 'dataCode',
      label: '申请单号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        col: 8,
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '请输入',
        addonBefore: '',
        autoCodeRule: 'meswarehouseChgApplyNo',
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '184c0d8c773b46fb9b49a141f24a3fc5',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        col: 4,
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编号', value: '1', key: 1 }],
        events: {
          change:
            "const code='dataCode';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        span: '',
        style: {},
      },
    },
    {
      key: 'b115b7ae63be4efc9c60f1a7952e6ba6',
      field: 'dataName',
      label: '申请主题',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入申请主题',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'f613107c60ba4c93b8b096108a317ca9',
      field: 'dataDate',
      label: '调拨日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        format: 'YYYY-MM-DD',
        rules: [],
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请选择',
        allowClear: true,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '0e960840ea4b4d2c81d882d860341225',
      field: 'dataUnit',
      label: '申请部门',
      type: 'organization',
      component: 'Dept',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        orgzType: 0,
        placeholder: '请选择申请部门',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'd623cc43dec0455b8c98660bdf2e637b',
      field: 'dataUser',
      label: '申请人员',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请选择申请人员',
        userType: 0,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '645f8bcc6e0f4bb0baed4c829dd8f6ce',
      field: 'dataPhone',
      label: '联系电话',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        col: 12,
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入联系电话',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '8c13d64a8e1840b0874e994f9176dc3c',
      field: 'inStorage',
      label: '调入仓库',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                { bindType: 'value', required: false, name: 'data_type', value: '0' },
                {
                  dataType: 'String',
                  bindType: '',
                  required: false,
                  name: 'warehouse_id',
                  value: '',
                },
                { dataType: 'String', bindType: '', required: false, name: 'area_id', value: '' },
                { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getWarehouseList',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
        },
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '196bc4d0a61b49f2a8c9419b4496cb61',
      field: 'outStorage',
      label: '调出仓库',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        col: 12,
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                { bindType: 'value', required: false, name: 'data_type', value: '0' },
                {
                  dataType: 'String',
                  bindType: '',
                  required: false,
                  name: 'warehouse_id',
                  value: '',
                },
                { dataType: 'String', bindType: '', required: false, name: 'area_id', value: '' },
                { dataType: 'String', bindType: '', required: false, name: 'parent_id', value: '' },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getWarehouseList',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
        },
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '9f55e8350b3a457b877eedfcd2a511fd',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入备注',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '163ca8e5d145471c87d392556ad121db',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '物品明细',
      componentProps: {
        color: '',
        defaultValue: '物品明细',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '8a23053744b942ce8d8d199b1c1569c3',
      label: '',
      field: 'mesWarehouseChgapplyDetailList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesWarehouseChgapplyDetailList',
        columns: [
          {
            key: 'eee3093b6f8e467d936b48efcc69eb29',
            title: '物品编码',
            dataIndex: 'productId',
            componentType: 'MultiplePopup',
            componentProps: {
              popupType: 'associate',
              rules: [],
              valueField: 'value',
              showLabel: true,
              required: false,
              labelField: 'label',
              datasourceType: 'api',
              dicOptions: [],
              width: '100%',
              apiConfig: {
                method: 'GET',
                script:
                  'var condition="";\r\nif(showLabel!=null&&showLabel=="code"){ \r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.code AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}else{\r\n    return db.select(\r\n    "SELECT t.id AS `key` ,t.id AS `value`,t.NAME AS label,t.*,c.type_name,p.property_name FROM case_erp_material t"\r\n    +"  LEFT JOIN case_erp_material_classes c ON c.id=t.classes_id "\r\n    +"LEFT JOIN case_erp_material_property p ON p.id=t.property_id "\r\n    +" WHERE t.state=1  "+condition)\r\n}\r\n',
                apiParams: [
                  {
                    tableInfo: [
                      { dataType: 'String', bindType: '', required: false, name: 'keyword' },
                      {
                        defaultValue: 'name',
                        dataType: 'String',
                        bindType: 'value',
                        description: '回显字段：code/name',
                        required: false,
                        name: 'showLabel',
                        value: 'code',
                      },
                    ],
                    title: 'Query Params',
                    key: '1',
                  },
                  { tableInfo: [], title: 'Header', key: '2' },
                  { title: 'Body', key: '3' },
                ],
                path: '/mes/getMaterialListByCheck',
                outputParams: [
                  {
                    show: true,
                    bindField: 'product_no',
                    name: 'product_no',
                    width: 150,
                    tableTitle: '物品编码',
                  },
                  {
                    show: true,
                    bindField: 'product_name',
                    name: 'product_name',
                    width: 150,
                    tableTitle: '物品名称',
                  },
                  {
                    show: true,
                    bindField: 'spe_model',
                    name: 'spe_model',
                    width: 150,
                    tableTitle: '规格型号',
                  },
                  {
                    show: true,
                    bindField: 'de_type',
                    name: 'de_type',
                    width: 150,
                    tableTitle: '类型',
                  },
                  {
                    show: true,
                    bindField: 'unity',
                    name: 'unity',
                    width: 150,
                    tableTitle: '单位',
                  },
                  {
                    show: true,
                    bindField: 'sys_num',
                    name: 'num',
                    width: 150,
                    tableTitle: '系统数量',
                  },
                ],
                apiId: 'copy1691116544397d71330',
              },
              disabled: false,
              placeholder: '请选择物品编码',
              events: {},
              span: '',
            },
          },
          {
            key: 'dd232ffeef5c4a05a500165ae1e824d9',
            title: '物品编码-隐藏',
            dataIndex: 'productNo',
            componentType: 'Input',
            defaultValue: '',
            show: false,
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入物品编码',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '8765f3697a6f4821a6212af437d4f211',
            title: '物品名称',
            dataIndex: 'productName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入物品名称',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '0e8d5f2d2aac4c5797e7688128c72133',
            title: '规格型号',
            dataIndex: 'speModel',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入规格型号',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '83263601af294f8987d360bf7e299391',
            title: '类型',
            dataIndex: 'deType',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入类型',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: 'ee99236b6f094d93bbe296fc882de364',
            title: '单位',
            dataIndex: 'unity',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入单位',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          {
            key: '2aaaf4fd09c44b66915a286f239463ce',
            title: '调拨数量',
            dataIndex: 'num',
            componentType: 'InputNumber',
            componentProps: {
              controls: true,
              //max: 100,
              rules: [],
              subTotal: false,
              showLabel: true,
              required: true,
              min: 0,
              width: '100%',
              step: 1,
              disabled: false,
              events: {},
              span: '',
              placeholder: '请输入',
            },
          },
          {
            key: '45c36907d9a546e4ac6422110bcd995d',
            title: '备注',
            dataIndex: 'remark',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              defaultValue: '',
              prefix: '',
              rules: [],
              suffix: '',
              addonAfter: '',
              showLabel: true,
              required: false,
              width: '100%',
              disabled: false,
              placeholder: '请输入备注',
              allowClear: false,
              addonBefore: '',
              events: {},
              span: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        buttonName: '选择数据',
        showIndex: false,
        useSelectButton: false,
        preloadType: 'api',
        showLabel: true,
        itemId: '',
        multipleHeads: [],
        dicOptions: [],
        showComponentBorder: true,
        apiConfig: {},
        showFormBorder: true,
        span: '24',
      },
    },
    {
      key: '32fe7102635a4a1ebc9fdd02c439eb2c',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '附件',
      componentProps: { color: '', defaultValue: '附件', align: 'left', fontSize: 15, style: {} },
    },
    {
      key: 'd07d87ffeaec4911bd1ad8d9c1b55aaa',
      field: 'dataFile',
      label: '上传组件',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        defaultValue: [],
        multiple: false,
        maxSize: 5,
        showLabel: false,
        required: false,
        accept: '',
        maxNumber: 5,
        disabled: false,
        events: {},
        span: '',
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
