import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'dataDate',
    label: '',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'keyword',
    label: '',
    component: 'Input',
    componentProps: {
      pplaceholder: '请输入产品编码或名称',
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'standard',
    title: '抽样标准',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'checkDate',
    title: '检测日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'checkUser',
    title: '检测人员',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'judgeResult',
    title: '检测结果',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'materialNo',
    title: '物料编码',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'materialName',
    title: '物料名称',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'typeName',
    title: '物料类别',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'model',
    title: '规格型号',
    componentType: 'select',

    sorter: true,
  },
  {
    dataIndex: 'samplingNum',
    title: '抽样数',
    componentType: 'input',
    sorter: true,
    align: 'right',
  },
  {
    dataIndex: 'errorNum',
    title: '不良数',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'errorRate',
    title: '不良率',
    componentType: 'textarea',

    sorter: true,
  },
];
