import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema1: FormSchema[] = [
  {
    field: 'toolNo',
    label: '销售订单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'toolNo',
    label: '产品名称',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns1: BasicColumn[] = [
  {
    dataIndex: 'toolNo',
    title: '销售单号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'onlineDate',
    title: '订单主题',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'productNo',
    title: '销售日期',
    componentType: 'date',

    sorter: true,
  },
  {
    dataIndex: 'productName',
    title: '客户名称',
    componentType: 'input',

    sorter: true,
  },
  {
    dataIndex: 'productName',
    title: '预发货日期',
    componentType: 'input',

    sorter: true,
  },
  {
    dataIndex: 'productName',
    title: '产品编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'productName',
    title: '产品名称',
    componentType: 'input',

    sorter: true,
  },
  {
    dataIndex: 'scheNum',
    title: '订单数量',
    componentType: 'number',

    sorter: true,
  },
  {
    dataIndex: 'scheNum',
    title: '排期数量',
    componentType: 'number',

    sorter: true,
  },

  {
    dataIndex: 'toolDate',
    title: '未排期数量',
    componentType: 'info',

    sorter: true,
  },
];
export const searchFormSchema: FormSchema[] = [
  {
    field: 'toolNo',
    label: '编号',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'toolNo',
    title: '编号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'onlineDate',
    title: '上线日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'productNo',
    title: '产品编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'productName',
    title: '产品名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'scheNum',
    title: '排期数量',
    componentType: 'number',

    sorter: true,
  },

  {
    dataIndex: 'toolDate',
    title: '制单日期',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'input',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'd46083173e8444c39d000b4a73937e1b',
      field: 'toolNo',
      label: '编号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '编号请输入',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        showLabel: true,
        autoCodeRule: 'mesProScheToolNo',
        required: false,
        style: { width: '100%' },
      },
    },
    {
      key: '6c65d59daffe43a29d95f53ab9d26e2f',
      field: 'onlineDate',
      label: '上线日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择上线日期',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '44e18cfb83da428d9912ed0ed1e86329',
      field: 'productNo',
      label: '产品编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入产品编码',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '0f434bade5ea4c57bc4c77ffb11d3d49',
      field: 'productName',
      label: '产品名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入产品名称',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'aed3aba99bf6452ca2215b2caa113a16',
      field: 'scheNum',
      label: '排期数量',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: null,
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: null,
        min: 0,
        //max: 100,
        step: 1,
        maxlength: null,
        disabled: false,
        showLabel: true,
        controls: true,
        required: false,
        subTotal: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '2cb65fef276240a785f35ddb356c84f4',
      field: 'toolDate',
      label: '制单日期',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 3,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        style: { width: '100%' },
      },
    },
    {
      key: 'f67048fe74c5455fa1e88da832801480',
      field: 'remark',
      label: '备注',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入备注',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '7698c87ea6c044dfa635fc3a732a449d',
      label: '明细',
      field: 'mesProSchetoolDetailList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesProSchetoolDetailList',
        columns: [
          {
            key: 'fc016ff5a8a34320898cbd67f503895b',
            title: '销售单号',
            dataIndex: 'saleId',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'e0b409c7ce8a4b24a7709d23675e0df1',
            title: '销售主题',
            dataIndex: 'saleName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: 'be3a9b47384244288af9c6081e621786',
            title: '客户名称',
            dataIndex: 'productId',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '38591fd4548c465189dec5a6d9ef124f',
            title: '产品编码',
            dataIndex: 'productNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '8a82b1b6881546debb9fa0617347d2da',
            title: '产品名称',
            dataIndex: 'productName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '85ce6a5483ec45318cdc66fb2386fe0c',
            title: '订单数量',
            dataIndex: 'saleNum',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '9a2ac37226b944639f02ce6f372d8382',
            title: '排期数量',
            dataIndex: 'scheNum',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: null,
              min: 0,
              //max: 100,
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: false,
              subTotal: false,
              rules: [],
              events: {},
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {},
        itemId: '',
        dicOptions: [],
        useSelectButton: false,
        buttonName: '选择数据',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
