import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: StoreManage分页参数 模型
 */
export interface StoreManagePageParams extends BasicPageParams {
  storeName: string;

  storeCode: string;

  storeRemark: string;

  appid: string;

  appsecret: string;

  storeUrl: string;
}
/**
 * @description: StoreApp分页参数 模型
 */
export interface StoreAppPageParams extends BasicPageParams {
  appStoreType?: string;

  storeId: string;
}
/**
 * @description: StoreManage分页返回值模型
 */
export interface StoreManagePageModel {
  id: string;

  storeName: string;

  storeCode: string;

  storeRemark: string;

  appid: string;

  appsecret: string;

  storeUrl: string;
}

/**
 * @description: StoreManage分页返回值结构
 */
export type StoreManagePageResult = BasicFetchResult<StoreManagePageModel>;
