import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

/**
 * @description: MesProOrder分页参数 模型
 */
export interface MesProOrderPageParams extends BasicPageParams {
  orderNo: string;

  priority: string;

  remark: string;

  createUserId: string;

  createDateStart: string;
  createDateEnd: string;
}

/**
 * @description: MesProOrder分页返回值模型
 */
export interface MesProOrderPageModel {
  id: string;

  orderNo: string;

  priority: string;

  remark: string;

  createUserId: string;

  createDate: string;
}

/**
 * @description: MesProOrder表类型
 */
export interface MesProOrderModel {
  id: number;

  isSysNum: string;

  orderNo: string;
  onlineDate: string;
  saleOrderNo: string;
  saleOrderId: string;

  orderName: string;
  productId: string;
  productNo: string;
  productName: string;
  orderUnit: string;

  priority: string;

  remark: string;

  inStoreState: number;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;

  mesProOrderDetailList?: MesProOrderDetailModel;
}

/**
 * @description: MesProOrderDetail表类型
 */
export interface MesProOrderDetailModel {
  id: number;

  orderId: number;

  orderNo: string;

  orderName: string;

  orderUnit: string;

  priority: string;

  saleOrderId: string;

  saleOrderNo: string;

  productId: string;

  productNo: string;

  productName: string;

  speModel: string;

  unity: string;

  planNum: string;

  onlineDate: string;

  remark: string;

  inStoreState: number;

  state: number;

  sort: number;

  createUserId: number;

  createDate: string;

  modifyUserId: number;

  modifyDate: string;

  deleteMark: number;

  enabledMark: number;
}

/**
 * @description: MesProOrder分页返回值结构
 */
export type MesProOrderPageResult = BasicFetchResult<MesProOrderPageModel>;
