import { BasicPageParams, BasicFetchResult } from '/@/api/model/baseModel';

export interface CustomerPageListParams {
  name?: string; //客户名称
  sourceId?: string; //来源
  typeId?: string; //客户类型
  startTime?: string; //添加开始时间
  endTime?: string; //添加结束时间
}

export interface CustomerAddParamsModel {
  name: string; //客户名称
  typeId: string; //客户类型
  industry: string; //所在行业
  sourceId: string; //来源
  scaleId?: string; //归属
  natureId?: string; //公司性质
  address: string; //地址
  filePath?: string; //图片地址
  caseErpCustomerContactsDtoList: CustomerContactsModel[]; //联系人
}

export interface CustomerUpdateParamsModel {
  id: string; //详情id
  name: string; //客户名称
  typeId: string; //客户类型
  industry: string; //所在行业
  sourceId: string; //来源
  scaleId?: string; //归属
  natureId?: string; //公司性质
  address: string; //地址
  filePath?: string; //图片地址
  caseErpCustomerContactsDtoList: CustomerContactsModel[]; //联系人
}

export interface CustomerInfoModel {
  name: string; //客户名称
  typeId: string; //客户类型
  industry: string; //所在行业
  sourceId: string; //来源
  scaleId?: string; //归属
  natureId?: string; //公司性质
  address: string; //地址
  filePath?: string; //图片地址
  caseErpCustomerContacts: CustomerContactsModel[]; //联系人
}

export interface CustomerDetailInfoModel {
  id: string; //详情id
  caseErpCustomerFollowInfoVoList: CustomerFollowModel[]; //跟进人
  caseErpCustomerContactsInfoVoList: CustomerContactsModel[]; //联系人
  caseErpLogList: CustomerLogModel[]; //操作信息
  caseErpCustomerVo: CustomerInfo; //客户基本信息
}

export interface CustomerListModel {
  id: string; //详情id
  name: string; //客户名称
  typeName: string; //客户类型
  defaultName: string; //联系人
  defaultPhone: string; //手机号码
  industry: string; //所在行业
  sourceName: string; //来源
  saleName: string; //归属
  createDate: string; //创建日期
  createUserName: string; //创建人
}

export interface FollowAddParamsModel {
  customerId: string; //客户id
  followTime?: string; //跟进时间
  nextFollowTime?: string; //下次跟进时间
  followTypeId?: string; //跟进方式
  content?: string; //说明
  filePath?: string; //图片上传
}

export interface FollowUpdateParamsModel {
  id: string; //详情id
  customerId: string; //客户id
  followTime?: string; //跟进时间
  nextFollowTime?: string; //下次跟进时间
  followTypeId?: string; //跟进方式
  content?: string; //说明
  filePath?: string; //图片上传
}

export interface ContactsAddParamsModel {
  customerId: string; //客户id
  caseErpCustomerContactsDtoList: CustomerContactsModel[];
}

export interface ContactsUpdateParamsModel {
  customerId: string; //客户id
  id: string; //详情id
  name: string; //名称
  phone?: string; //手机号
  post?: string; //岗位
  dept?: string; //部门
  isDefault: number; //是否默认 1-是 2-否
}

export interface TransferParamsModel {
  id: string; //详情id
  saleIds: string; //转移人员Id
}

export interface CustomerLogModel {
  operateUserAccount: string; //操作人
  createDate: string; //操作时间
  executeResultJson?: string; //操作内容
}

export interface CustomerContactsModel {
  name: string; //名称
  phone?: string; //手机号
  post?: string; //岗位
  dept?: string; //部门
  isDefault: number; //是否默认 1-是 2-否
  createDate?: string; //创建日期
  createUserName?: string; //创建人
}

export interface CustomerFollowModel {
  followTime?: string; //跟进时间
  nextFollowTime?: string; //下次跟进时间
  followTypeName?: string; //跟进方式
  content?: string; //说明
  createUserName?: string; //跟进人
}

export interface CustomerInfo {
  name: string; //名称
  typeName?: string; //客户类型
  industry?: string; //行业
  sourceName?: string; //来源
  scaleName?: string; //规模
  natureName?: string; //公司性质
  address?: string; //地址
  saleName?: string; //归属
  filePath?: string; //图片地址
  createDate: string; //创建日期
  createUserName: string; //创建人
}

export type CustomerPageListSearchModel = BasicPageParams & CustomerPageListParams;
export type CustomerPageListResultModel = BasicFetchResult<CustomerListModel>;
