import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'workNo',
    label: '工单编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'state',
    label: '状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '待下发', value: '0' },
        { key: 2, label: '待生产', value: '1' },
        { key: 3, label: '生产中', value: '2' },
        { key: 4, label: '已完成', value: '8' },
        { key: 5, label: '已关闭', value: '9' },
        { key: 6, label: '已暂停', value: '7' },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'priority',
    label: '优先级',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'dic',
      params: { itemId: '1689840965516009473' },
      labelField: 'name',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'planId',
    label: '生产计划编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'orderNo',
    label: '生产订单编号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'materialNo',
    label: '物料编码',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'materialName',
    label: '物料名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'planNum',
    label: '计划产量',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'unity',
    label: '单位',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'carId',
    label: '车间',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/mesFactory',
        method: 'GET',
        apiId: '6b4b40b3db664831b709f56bc98a7f04',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'factory_type',
                value: '1',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'factory_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'car_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'parent_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1  and delete_mark=0 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'lineId',
    label: '产线',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/mesFactory',
        method: 'GET',
        apiId: '6b4b40b3db664831b709f56bc98a7f04',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'factory_type',
                value: '2',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'factory_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'car_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'parent_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1  and delete_mark=0 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'craftId',
    label: '工艺',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getProcessTechList',
        method: 'GET',
        apiId: 'copy1691738160514d20686',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'keyword',
                value: null,
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'showLabel',
                value: '',
                description: '回显字段',
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: 'name',
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'queryType',
                value: null,
                description: '查询类型',
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'state',
                value: null,
                description: '状态',
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.process_name AS label,t.*  FROM mes_process_technology t WHERE 1=1  and delete_mark=0 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'saleOrderNo',
    label: '销售单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'createUserId',
    label: '创建人',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'workNo',
    title: '工单编号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '待下发', value: '0' },
        { key: 2, label: '待生产', value: '1' },
        { key: 3, label: '生产中', value: '2' },
        { key: 4, label: '已完成', value: '8' },
        { key: 5, label: '已关闭', value: '9' },
        { key: 6, label: '已暂停', value: '7' },
      ];
      return staticOptions.filter((x) => x.value === record.state)[0]?.label;
    },
    sorter: true,
  },

  {
    dataIndex: 'priority',
    title: '优先级',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'planStartDate',
    title: '计划开工日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'planEndDate',
    title: '计划完工日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'realStartDate',
    title: '实际开工日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'realEndDate',
    title: '实际完工日期',
    componentType: 'date',

    sorter: true,
  },

  {
    dataIndex: 'materialNo',
    title: '物料编码',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'materialName',
    title: '物料名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'planNum',
    title: '计划产量',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'unity',
    title: '单位',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'carId',
    title: '车间',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'lineId',
    title: '产线',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'craftId',
    title: '工艺',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'orderNo',
    title: '生产订单编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'planId',
    title: '生产计划编号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'saleOrderNo',
    title: '销售单号',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '创建人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '创建时间',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '93d71b50c23043c68d50651032c24683',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '生产计划信息',
      componentProps: {
        defaultValue: '生产计划信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '29550069991945deae776ccc8f05708c',
      field: 'planId',
      label: '生产计划ID',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入生产计划ID',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'f6bc6b8299bb4ba1bacf781b9e332f6c',
      field: 'planId',
      label: '生产计划编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入生产计划编号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'f04d918cf324462d80b74bb71ae59d18',
      field: 'orderId',
      label: '生产订单id',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '生产订单id请输入',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'a879487fa00a4b4a9e30f70f5265dee7',
      field: 'orderNo',
      label: '生产订单编号',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入生产订单编号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '40bf6f7b83dc45f588c75276773fe01d',
      field: 'priority',
      label: '优先级',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'dic',
        params: { itemId: '1689840965516009473' },
        labelField: 'name',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        itemId: '1689840965516009473',
        style: { width: '100%' },
      },
    },
    {
      key: '73344c3237474bbfa3a396445c0cf12a',
      field: 'realStartDate',
      label: '实际开工日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择实际开工日期',
        format: 'YYYY-MM-DD HH:mm:ss',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'a0ef9a64844c4d5a97109b37cf273641',
      field: 'realEndDate',
      label: '实际完工日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择实际完工日期',
        format: 'YYYY-MM-DD HH:mm:ss',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'fea20dd53d574a5abdab1be0766b514f',
      field: 'materialId',
      label: '物料ID',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入物料ID',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'fcef1a18b8524d7399b701eb4a0febc1',
      field: 'materialNo',
      label: '物料编码',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入物料编码',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '242136739ee64c679a996d9fe87675f9',
      field: 'materialName',
      label: '物料名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入物料名称',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '086668966b0c437599bcd29cd2edd9b3',
      field: 'planNum',
      label: '计划产量',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入计划产量',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'd41ecd666a624fc38de15a6be7b3ac9d',
      field: 'unity',
      label: '单位',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入单位',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'a1bd39c71c274918be5f5bd41feb001a',
      field: 'carId',
      label: '车间',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '1',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'parent_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1  and delete_mark=0 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '1ddac43b1c9e4b62a0475e80209665a1',
      field: 'lineId',
      label: '产线',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/mesFactory',
          method: 'GET',
          apiId: '6b4b40b3db664831b709f56bc98a7f04',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'factory_type',
                  value: '2',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'factory_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'car_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'parent_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(factory_type!=null&&factory_type!=""){ //0-工厂、1-车间、2产线,3-工位\r\n    condition+=" and factory_type=#{factory_type}";\r\n}\r\nif(factory_id!=null&&factory_id!=""){ \r\n    condition+=" and factory_id=#{factory_id}";\r\n}\r\nif(car_id!=null&&car_id!=""){ \r\n    condition+=" and car_id=#{car_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(factory_name) AS label,t.* FROM mes_base_factory t where 1=1  and delete_mark=0 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'd5c9d26ccabe4e9abd4ac3d3d313c97f',
      field: 'craftId',
      label: '工艺',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getProcessTechList',
          method: 'GET',
          apiId: 'copy1691738160514d20686',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'showLabel',
                  value: '',
                  description: '回显字段',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'name',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'queryType',
                  value: null,
                  description: '查询类型',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'state',
                  value: null,
                  description: '状态',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,t.process_name AS label,t.*  FROM mes_process_technology t WHERE 1=1  and delete_mark=0 "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: 'fba44879ed924e2eafa0a2d1430f6a8c',
      field: 'saleOrderNo',
      label: '销售单号',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入销售单号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'f3da269168d24308857a28dec971cd75',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '工单信息',
      componentProps: {
        defaultValue: '工单信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'b706ea33dbe34e22b9c2a36458726849',
      field: 'workNo',
      label: '工单编号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '工单编号请输入',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        showLabel: true,
        autoCodeRule: 'mesProOrderWorkNo',
        required: false,
        col: 8,
        style: { width: '100%' },
      },
    },
    {
      key: '20ea35c5d0ee48d08125467a6f375146',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        span: '',
        showLabel: true,
        disabled: false,
        staticOptions: [{ key: 1, label: '使用系统编码', value: '1' }],
        datasourceType: 'staticData',
        defaultSelect: '1',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        col: 4,
        style: {},
      },
    },
    {
      key: '7d4c9821325446719891ac68ce24e5c5',
      field: 'planStartDate',
      label: '计划开工日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'aebe4718acb2488b8a784f02b55933e0',
      field: 'planEndDate',
      label: '计划完工日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        defaultValue: '',
        width: '100%',
        placeholder: '请选择',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'a385ffd467b345b3b13da3c9d5070a22',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '6ff7e306d23840c1969e598e7d4b79c8',
      field: 'state',
      label: '状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 24 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: '待下发', value: '0' },
          { key: 2, label: '待生产', value: '1' },
          { key: 3, label: '生产中', value: '2' },
          { key: 4, label: '已完成', value: '8' },
          { key: 5, label: '已关闭', value: '9' },
          { key: 6, label: '已暂停', value: '7' },
        ],
        defaultSelect: '0',
        datasourceType: 'staticData',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        col: 0,
        style: { width: '100%' },
      },
    },
    {
      key: '188bcfe9940a46a28e78e143b124b7d8',
      field: 'createUserId',
      label: '创建人',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 0,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        col: 0,
        style: { width: '100%' },
      },
    },
    {
      key: '000a599d3e994dd8a4d086598949c877',
      field: 'createDate',
      label: '创建时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 24 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        placeholder: '',
        infoType: 3,
        loadAgain: false,
        showLabel: true,
        disabled: true,
        col: 0,
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
