import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'outCode',
    label: '出库单号',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'outType',
    label: '出库类型',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'staticData',
      staticOptions: [
        { key: 1, label: '请选择', value: '' },
        { key: 2, label: '领用出库', value: '1' },
        { key: 3, label: '委外领用', value: '2' },
        { key: 4, label: '销售出库', value: '3' },
        { key: 6, label: '采购退货出库', value: '4' },
        { key: 6, label: '其他出库', value: '0' },
      ],
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'outName',
    label: '出库主题',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'outDate',
    label: '出库日期',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },

  {
    field: 'recUnit',
    label: '申领部门',
    component: 'Dept',
    componentProps: {
      placeholder: '请选择',
      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'recUser',
    label: '申领人员',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'outStorage',
    label: '出库仓库',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getWarehouseList',
        method: 'GET',
        apiId: 'd5acd359b8c6490caa8291712d2a2127',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'data_type',
                value: '0',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
              {
                name: 'warehouse_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
              },
              {
                name: 'area_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
              },
              {
                name: 'parent_id',
                value: '',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'outDouser',
    label: '出库操作人员',
    component: 'User',
    componentProps: {
      suffix: 'ant-design:setting-outlined',
      placeholder: '请选择',
    },
    colProps: { span: 8 },
  },

  {
    field: 'relevancePro',
    label: '关联项目',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        path: '/mes/getProductList',
        method: 'GET',
        apiId: 'copy1690966485191d74232',
        apiParams: [
          {
            key: '1',
            title: 'Query Params',
            tableInfo: [
              {
                name: 'keyword',
                value: null,
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: '',
              },
              {
                name: 'product_state',
                value: '1',
                description: null,
                required: false,
                dataType: 'String',
                type: null,
                defaultValue: null,
                validateType: null,
                error: null,
                expression: null,
                children: null,
                bindType: 'value',
              },
            ],
          },
          { key: '2', title: 'Header', tableInfo: [] },
          { key: '3', title: 'Body' },
        ],
        script:
          'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,CONCAT(t.code,\'-\',t.name)  AS label,t.* FROM mes_product t where 1=1  "+condition)',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'remark',
    label: '备注',
    component: 'Input',
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'outCode',
    title: '出库单号',
    componentType: 'auto-code',

    sorter: true,
  },

  {
    dataIndex: 'outName',
    title: '出库主题',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'outType',
    title: '出库类型',
    componentType: 'select',

    customRender: ({ record }) => {
      const staticOptions = [
        { key: 1, label: '请选择', value: '' },
        { key: 2, label: '领用出库', value: '1' },
        { key: 3, label: '委外领用', value: '2' },
        { key: 4, label: '销售出库', value: '3' },
        { key: 6, label: '采购退货出库', value: '4' },
        { key: 6, label: '其他出库', value: '0' },
      ];
      return staticOptions.filter((x) => x.value === record.outType)[0]?.label;
    },
    sorter: true,
  },

  {
    dataIndex: 'outDate',
    title: '出库日期',
    componentType: 'date',

    sorter: true,
  },
  {
    dataIndex: 'products',
    title: '物品摘要',
    componentType: 'input',
    sorter: true,
    align: 'right',
  },
  {
    dataIndex: 'recUnit',
    title: '申领部门',
    componentType: 'organization',

    sorter: true,
  },

  {
    dataIndex: 'recUser',
    title: '申领人员',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'outStorage',
    title: '出库仓库',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'outNum',
    title: '出库数量',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'outPrice',
    title: '总金额',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'outDouser',
    title: '出库操作人员',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'relevancePro',
    title: '关联项目',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'remark',
    title: '备注',
    componentType: 'textarea',

    sorter: true,
  },
  {
    dataIndex: 'state',
    title: '状态',
    componentType: 'input',
    sorter: true,
  },
];

export const formProps: FormProps = {
  labelWidth: '120px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: 'b3e7dab8e840408db4f75c49ee113d55',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '基础信息',
      componentProps: {
        defaultValue: '基础信息',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: '7a3ae6ca6d0b4ac89e6214ca8d727b66',
      field: 'outCode',
      label: '出库单号',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '出库单号出库单号出库单号请输入',
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        showLabel: true,
        autoCodeRule: 'mesoutWarehouseNo',
        required: true,
        col: 8,
        style: { width: '100%' },
      },
    },
    {
      key: '1f4b5c8a6f3043d48e2269f0f2f7fd64',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      ifShow: true,
      componentProps: {
        span: '',
        showLabel: false,
        disabled: false,
        staticOptions: [{ key: 1, label: '用系统编号', value: '1' }],
        datasourceType: 'staticData',
        defaultSelect: '1',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: false,
        rules: [],
        events: {
          change:
            "const code='outCode';//编码字段名\nif(formModel.isSysNum==1){\n\tformModel[code]=formModel.codeTemp; formActionType.updateSchema({field:code,componentProps: {readonly:true}});\n}else{\n  formModel.codeTemp=formModel[code];\n  formModel[code]='';\nformActionType.updateSchema({field:code,componentProps: {readonly:false}});\n}",
        },
        col: 4,
        style: {},
      },
    },
    {
      key: 'd016624691144911bf0ef73e0f30b5fd',
      field: 'outType',
      label: '出库类型',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '出库类型请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: '请选择', value: '' },
          { key: 2, label: '领用出库', value: '1' },
          { key: 3, label: '委外领用', value: '2' },
          { key: 4, label: '销售出库', value: '3' },
          { key: 6, label: '采购退货出库', value: '4' },
          { key: 6, label: '其他出库', value: '0' },
        ],
        defaultSelect: '',
        datasourceType: 'staticData',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {},
        dicOptions: [],
        required: true,
        rules: [],
        events: {
          change:
            "\n//1领用出库、2委外领用、3销售出库、4采购退货出库、0-其他出库\nif(formModel.outType=='1'){\nformActionType.updateSchema({field:'recUnit',ifShow:true,label:'申领部门',componentProps:{}});\nformActionType.updateSchema({field:'recUser',ifShow:true,label:'申领人员',componentProps:{}});\n\nformActionType.updateSchema({field:'outStorage',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'outNum',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'produceId',ifShow:true,componentProps:{}});\nformActionType.updateSchema({field:'produceNo',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'saleId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'saleNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'saleCustomer',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'buyId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'buyNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'buyUser',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplier',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierUser',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierPhone',ifShow:false,componentProps:{}});\n}\nif(formModel.outType=='2'){\nformActionType.updateSchema({field:'recUnit',ifShow:true,label:'申领部门',componentProps:{}});\nformActionType.updateSchema({field:'recUser',ifShow:true,label:'申领人员',componentProps:{}});\n\nformActionType.updateSchema({field:'outStorage',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'outNum',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'produceId',ifShow:true,componentProps:{}});\nformActionType.updateSchema({field:'produceNo',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'saleId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'saleNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'saleCustomer',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'buyId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'buyNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'buyUser',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplier',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierUser',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierPhone',ifShow:false,componentProps:{}});\n}\nif(formModel.outType=='3'){\nformActionType.updateSchema({field:'recUnit',ifShow:true,label:'申领部门',componentProps:{}});\nformActionType.updateSchema({field:'recUser',ifShow:true,label:'申领人员',componentProps:{}});\n\nformActionType.updateSchema({field:'outStorage',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'outNum',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'produceId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'produceNo',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'saleId',ifShow:true,componentProps:{}});\nformActionType.updateSchema({field:'saleNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'saleCustomer',ifShow:true,componentProps:{}});\n\nformActionType.updateSchema({field:'buyId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'buyNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'buyUser',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplier',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierUser',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierPhone',ifShow:false,componentProps:{}});\n}\nif(formModel.outType=='4'){\nformActionType.updateSchema({field:'recUnit',ifShow:true,label:'申领部门',componentProps:{}});\nformActionType.updateSchema({field:'recUser',ifShow:true,label:'申领人员',componentProps:{}});\n\nformActionType.updateSchema({field:'outStorage',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'outNum',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'produceId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'produceNo',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'saleId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'saleNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'saleCustomer',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'buyId',ifShow:true,componentProps:{}});\nformActionType.updateSchema({field:'buyNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'buyUser',ifShow:true,componentProps:{}});\nformActionType.updateSchema({field:'supplier',ifShow:true,componentProps:{}});\nformActionType.updateSchema({field:'supplierId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierUser',ifShow:true,componentProps:{}});\nformActionType.updateSchema({field:'supplierPhone',ifShow:true,componentProps:{}});\n}\nif(formModel.outType=='0'){\nformActionType.updateSchema({field:'recUnit',ifShow:true,label:'申领部门',componentProps:{}});\nformActionType.updateSchema({field:'recUser',ifShow:true,label:'申领人员',componentProps:{}});\n\nformActionType.updateSchema({field:'outStorage',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'outNum',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'produceId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'produceNo',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'saleId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'saleNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'saleCustomer',ifShow:false,componentProps:{}});\n\nformActionType.updateSchema({field:'buyId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'buyNo',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'buyUser',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplier',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierId',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierUser',ifShow:false,componentProps:{}});\nformActionType.updateSchema({field:'supplierPhone',ifShow:false,componentProps:{}});\n}",
        },
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '3a555fbba16145c69ababe3aa7e0c379',
      field: 'outName',
      label: '出库主题',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入出库主题',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '75c08a41c32f420ba51997ff327f41d4',
      field: 'outDate',
      label: '出库日期',
      type: 'date',
      component: 'DatePicker',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '2023-08-02',
      componentProps: {
        span: '',
        defaultValue: '2023-08-02',
        width: '100%',
        placeholder: '请选择出库日期',
        format: 'YYYY-MM-DD',
        showLabel: true,
        allowClear: true,
        disabled: false,
        required: true,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '596ec20dbc3746968160a435dc2dc165',
      field: 'buyId',
      label: '采购订单',
      type: 'associate-popup',
      component: 'MultiplePopup',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        popupType: 'associate',
        width: '100%',
        span: '',
        placeholder: '请选择采购订单',
        showLabel: true,
        disabled: false,
        datasourceType: 'api',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getBuyOrderList',
          method: 'GET',
          apiId: 'copy1690947273832d8798',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT * FROM case_erp_purchase where 1=1  "+condition)',
          outputParams: [
            {
              name: 'purchase_number',
              tableTitle: '采购订单号',
              bindField: 'buy_no',
              show: true,
              width: 150,
            },
            {
              name: 'supplier_name',
              tableTitle: '供应商',
              bindField: 'supplier',
              show: true,
              width: 150,
            },
            {
              name: 'supplier_person',
              tableTitle: '联系人',
              bindField: 'supplier_user',
              show: true,
              width: 150,
            },
            {
              name: 'purchase_phone',
              tableTitle: '联系电话',
              bindField: 'supplier_phone',
              show: true,
              width: 150,
            },
            {
              name: 'purchase_date',
              tableTitle: '采购日期',
              bindField: '',
              show: true,
              width: 150,
            },
            {
              name: 'supplier_id',
              tableTitle: '供应商ID',
              bindField: 'supplier_id',
              show: false,
              width: 150,
            },
            { name: 'remark', tableTitle: '备注', bindField: '', show: true, width: 150 },
          ],
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        params: null,
        defaultSelect: '',
        itemId: '1419276800524423168',
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'd9d647bd0d7548eb9ac99746e28d07eb',
      field: 'buyNo',
      label: '采购订单号',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入采购订单号',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '68021729118c4c29b3944e585c970c44',
      field: 'supplierId',
      label: '供应商id',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入供应商id',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '2bccf61266454ae6825ecfa6507b514c',
      field: 'supplier',
      label: '供应商',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入供应商',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'cb83fa99faa7480383b67944ceac6cd9',
      field: 'supplierUser',
      label: '联系人',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '联系人请输入',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '01dc473bb4a7428987332110ccc2fd12',
      field: 'supplierPhone',
      label: '联系电话',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入联系电话',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '08e4132bf7f4445685cb1f33502dc1e8',
      field: 'produceId',
      label: '生产单号',
      type: 'associate-popup',
      component: 'MultiplePopup',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        popupType: 'associate',
        width: '100%',
        span: '',
        placeholder: '请选择生产单号',
        showLabel: true,
        disabled: false,
        datasourceType: 'api',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getProduceOrderList',
          method: 'GET',
          apiId: 'copy1690957937043d38766',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT * FROM case_erp_purchase where audit_state=3  "+condition)',
          outputParams: [
            {
              name: 'order_no',
              tableTitle: '生产单号',
              bindField: 'produce_no',
              show: true,
              width: 150,
            },
            { name: 'order_unit', tableTitle: '生产主题', bindField: null, show: true, width: 150 },
            { name: 'order_unit', tableTitle: '生产部门', bindField: '', show: true, width: 150 },
            { name: 'product_name', tableTitle: '产品名称', bindField: '', show: true, width: 150 },
            { name: 'spe_model', tableTitle: '规格型号', bindField: '', show: true, width: 150 },
            {
              name: 'in_store_state',
              tableTitle: '入库状态',
              bindField: '',
              show: true,
              width: 150,
            },
          ],
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'bfe53bd6d7e048b591a4a7c0721d2c2f',
      field: 'produceNo',
      label: '生产单号-回显',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入生产单号-回显-回显',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '55adc868480748cfa7a3df9deedc4bac',
      field: 'saleId',
      label: '销售单号',
      type: 'associate-popup',
      component: 'MultiplePopup',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        popupType: 'associate',
        width: '100%',
        span: '',
        placeholder: '请选择销售单号',
        showLabel: true,
        disabled: false,
        datasourceType: 'api',
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getSaleOrderList',
          method: 'GET',
          apiId: 'copy1690958013341d31983',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT * FROM case_erp_purchase where audit_state=3  "+condition)',
          outputParams: [
            {
              name: 'sale_number',
              tableTitle: '销售单号',
              bindField: 'sale_no',
              show: true,
              width: 150,
            },
            { name: 'theme', tableTitle: '主题', bindField: null, show: true, width: 150 },
            {
              name: 'customer_name',
              tableTitle: '客户姓名',
              bindField: 'sale_customer',
              show: true,
              width: 150,
            },
            { name: 'sale_date', tableTitle: '销售日期', bindField: '', show: true, width: 150 },
            {
              name: 'client_number',
              tableTitle: '客户订单号',
              bindField: '',
              show: true,
              width: 150,
            },
            {
              name: 'out_store_state',
              tableTitle: '出库状态',
              bindField: '',
              show: true,
              width: 150,
            },
            { name: 'remark', tableTitle: '备注', bindField: '', show: true, width: 150 },
          ],
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'aaee7c7283dd4a73a228c847a8328ca8',
      field: 'saleNo',
      label: '销售单号-回显',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入销售单号-回显',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '5a34970db40f4e78b8ba2b9570224e04',
      field: 'saleCustomer',
      label: '客户姓名',
      type: 'input',
      component: 'Input',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入客户姓名',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: 'd94fcc9bfc02489ea8029678b6ed1f3c',
      field: 'recUnit',
      label: '申领部门',
      type: 'organization',
      component: 'Dept',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        span: '',
        width: '100%',
        orgzType: 0,
        placeholder: '请选择申领部门',
        showLabel: true,
        disabled: false,
        required: false,
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '46b22a7568c04cbbb41058ce86b7c4cf',
      field: 'recUser',
      label: '申领人员',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        span: '',
        width: '100%',
        defaultValue: '',
        placeholder: '请选择申领人员',
        userType: 0,
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        disabled: false,
        required: false,
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '936a845b890c4b9880f30bc988a3e422',
      field: 'outStorage',
      label: '出库仓库',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: 'Option 1' },
          { key: 2, label: 'Option 2', value: 'Option 2' },
          { key: 3, label: 'Option 3', value: 'Option 3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getWarehouseList',
          method: 'GET',
          apiId: 'd5acd359b8c6490caa8291712d2a2127',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'data_type',
                  value: '0',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
                {
                  name: 'warehouse_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                },
                {
                  name: 'area_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                },
                {
                  name: 'parent_id',
                  value: '',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\nif(data_type!=null&&data_type!=""){ \r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
        },
        dicOptions: [],
        required: true,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '7cebc1de01724b698aaa03d19fa44e15',
      field: 'outNum',
      label: '出库数量',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入出库数量',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '578ffab1b302459d94eb41f56ca557b5',
      field: 'outPrice',
      label: '总金额',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      ifShow: false,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入总金额',
        maxlength: null,
        prefix: '',
        suffix: '',
        addonBefore: '',
        addonAfter: '',
        disabled: false,
        allowClear: false,
        showLabel: true,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '6c577d94627243b09f654116e732a17b',
      field: 'outDouser',
      label: '出库操作人员',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        span: '',
        width: '100%',
        defaultValue: '',
        placeholder: '请选择人员',
        userType: 0,
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        disabled: false,
        required: true,
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '363859a943334da69ddaf565d477c61f',
      field: 'relevancePro',
      label: '关联项目',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      ifShow: true,
      componentProps: {
        width: '100%',
        span: '',
        placeholder: '请选择',
        showLabel: true,
        showSearch: false,
        clearable: false,
        disabled: false,
        staticOptions: [
          { key: 1, label: 'Option 1', value: '1' },
          { key: 2, label: 'Option 2', value: '2' },
          { key: 3, label: 'Option 3', value: '3' },
        ],
        defaultSelect: '',
        datasourceType: 'api',
        params: null,
        labelField: 'label',
        valueField: 'value',
        apiConfig: {
          path: '/mes/getProductList',
          method: 'GET',
          apiId: 'copy1690966485191d74232',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'product_state',
                  value: '1',
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'value',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition="";\r\n\r\nreturn db.select("SELECT t.id AS `key` ,t.id AS `value`,CONCAT(t.code,\'-\',t.name)  AS label,t.* FROM mes_product t where 1=1  "+condition)',
        },
        dicOptions: [],
        required: false,
        rules: [],
        events: {},
        col: 12,
        style: { width: '100%' },
      },
    },
    {
      key: '35502bcad33342659287becbc9118d10',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '备注请输入',
        maxlength: null,
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '8970174dc1484539a7b3dd01c15d3bc1',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '物品明细',
      componentProps: {
        defaultValue: '物品明细',
        color: '',
        align: 'left',
        fontSize: 15,
        style: {},
      },
    },
    {
      key: 'b9958a412fe44ab7b8b72cb401ca357a',
      label: '',
      field: 'mesWarehouseOutDetailList',
      type: 'form',
      component: 'SubForm',
      required: true,
      colProps: { span: 24 },
      componentProps: {
        mainKey: 'mesWarehouseOutDetailList',
        columns: [
          {
            key: '5707278f9ac94a95b1d74eebcc135bb9',
            title: '物品ID',
            dataIndex: 'productId',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '物品ID请输入物品ID',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'id',
            },
          },
          {
            key: '8ca9bdf071af4d089a8a990dd6cfe38b',
            title: '物品编码',
            dataIndex: 'productNo',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '请输入物品编码',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'code',
            },
          },
          {
            key: '5b123250db4148e8b197a2191e32dc81',
            title: '物品名称',
            dataIndex: 'productName',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'name',
            },
          },
          {
            key: 'eaf6f3cf87e34e89bb26281324083b6e',
            title: '规格型号',
            dataIndex: 'speModel',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'model',
            },
          },
          {
            key: 'a49380a4287f48dbb7ac3f631799d1c3',
            title: '单位',
            dataIndex: 'unity',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'unit_name',
            },
          },
          {
            key: 'e3b47a95d51e4094ac36cd0b0c4c026e',
            title: '库区',
            dataIndex: 'warArea',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: false,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/getWarehouseList',
                method: 'GET',
                apiId: 'd5acd359b8c6490caa8291712d2a2127',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'data_type',
                        value: '1',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'warehouse_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'area_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'parent_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '1c57e1d028144826bfe6f384f4591ddc',
            title: '库位',
            dataIndex: 'locationId',
            componentType: 'XjrSelect',
            componentProps: {
              width: '100%',
              span: '',
              placeholder: '',
              showLabel: true,
              showSearch: false,
              clearable: false,
              disabled: false,
              staticOptions: [
                { key: 1, label: 'Option 1', value: 'Option 1' },
                { key: 2, label: 'Option 2', value: 'Option 2' },
                { key: 3, label: 'Option 3', value: 'Option 3' },
              ],
              defaultSelect: '',
              datasourceType: 'api',
              params: null,
              labelField: 'label',
              valueField: 'value',
              apiConfig: {
                path: '/mes/getWarehouseList',
                method: 'GET',
                apiId: 'd5acd359b8c6490caa8291712d2a2127',
                apiParams: [
                  {
                    key: '1',
                    title: 'Query Params',
                    tableInfo: [
                      {
                        name: 'data_type',
                        value: '2',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: 'value',
                      },
                      {
                        name: 'warehouse_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'area_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                      {
                        name: 'parent_id',
                        value: '',
                        description: null,
                        required: false,
                        dataType: 'String',
                        type: null,
                        defaultValue: null,
                        validateType: null,
                        error: null,
                        expression: null,
                        children: null,
                        bindType: '',
                      },
                    ],
                  },
                  { key: '2', title: 'Header', tableInfo: [] },
                  { key: '3', title: 'Body' },
                ],
                script:
                  'var condition="";\r\nif(data_type!=null&&data_type!=""){ //类型（0-仓库、1-库区、2-库位）\r\n    condition+=" and data_type=#{data_type}";\r\n}\r\nif(warehouse_id!=null&&warehouse_id!=""){ \r\n    condition+=" and warehouse_id=#{warehouse_id}";\r\n}\r\nif(area_id!=null&&area_id!=""){ \r\n    condition+=" and area_id=#{area_id}";\r\n}\r\nif(parent_id!=null&&parent_id!=""){ \r\n    condition+=" and parent_id=#{parent_id}";\r\n}\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(data_code,\'-\',data_name) AS label FROM mes_base_warehouse where 1=1 "+condition)',
              },
              dicOptions: [],
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '4a28e1b55de84c6ab1f2ad2e6ab2f5d9',
            title: '批次号',
            dataIndex: 'batchno',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: '',
            },
          },
          {
            key: '321aeb8b88a5424c8f6f2a8a0b3e9c55',
            title: '出库数量',
            dataIndex: 'num',
            componentType: 'InputNumber',
            defaultValue: null,
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: null,
              min: 0,
              //max: 100,
              step: 1,
              maxlength: null,
              disabled: false,
              showLabel: true,
              controls: true,
              required: true,
              subTotal: false,
              rules: [],
              events: {},
              prestrainField: '',
            },
          },
          {
            key: '95a5ede565fa480e8e3f955e55245300',
            title: '单价',
            dataIndex: 'price',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'price',
            },
          },
          {
            key: '0f4795654f6c412abe604382d0fc7413',
            title: '合计',
            dataIndex: 'totalPrice',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: 'total_price',
            },
          },
          {
            key: 'f520f562c4d84e2f9972f854badbbbe6',
            title: '生产日期',
            dataIndex: 'produceDate',
            componentType: 'DatePicker',
            defaultValue: '',
            componentProps: {
              span: '',
              defaultValue: '',
              width: '100%',
              placeholder: '',
              format: 'YYYY-MM-DD',
              showLabel: true,
              allowClear: true,
              disabled: false,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '25c42598620f4f8fb89757b12eea9b40',
            title: '到期日期',
            dataIndex: 'endDate',
            componentType: 'DatePicker',
            defaultValue: '',
            componentProps: {
              span: '',
              defaultValue: '',
              width: '100%',
              placeholder: '',
              format: 'YYYY-MM-DD',
              showLabel: true,
              allowClear: true,
              disabled: false,
              required: false,
              rules: [],
              events: {},
            },
          },
          {
            key: '99510f3b8c6b429ca3c3e748a1c0b14a',
            title: '备注',
            dataIndex: 'remark',
            componentType: 'Input',
            defaultValue: '',
            componentProps: {
              width: '100%',
              span: '',
              defaultValue: '',
              placeholder: '',
              maxlength: null,
              prefix: '',
              suffix: '',
              addonBefore: '',
              addonAfter: '',
              disabled: false,
              allowClear: false,
              showLabel: true,
              required: false,
              rules: [],
              events: {},
              prestrainField: '',
            },
          },
          { title: '操作', key: 'action', fixed: 'right', width: '50px' },
        ],
        span: '24',
        preloadType: 'api',
        apiConfig: {
          path: '/mes/getOutStoreMaterialList',
          method: 'GET',
          apiId: 'copy1691376953075d25524',
          apiParams: [
            {
              key: '1',
              title: 'Query Params',
              tableInfo: [
                {
                  name: 'keyword',
                  value: null,
                  description: null,
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'purchase_id',
                  value: 'buy_no',
                  description: '采购订单id',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'data',
                },
                {
                  name: 'showLabel',
                  value: '',
                  description: '回显字段',
                  required: false,
                  dataType: 'String',
                  type: null,
                  defaultValue: 'code',
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: '',
                },
                {
                  name: 'queryType',
                  value: 'out_type',
                  description: '查询类型：1-采购',
                  required: false,
                  dataType: null,
                  type: null,
                  defaultValue: null,
                  validateType: null,
                  error: null,
                  expression: null,
                  children: null,
                  bindType: 'data',
                },
              ],
            },
            { key: '2', title: 'Header', tableInfo: [] },
            { key: '3', title: 'Body' },
          ],
          script:
            'var condition=" and purchase_id=#{purchase_id}";\r\n// if(purchase_id!=null&&purchase_id!=""){ \r\n//     condition+=" and purchase_id=#{purchase_id}";\r\n// }\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CODE AS label,t.*,t.price*t.count as total_price,t.price*t.return_count as out_total_price FROM case_erp_purchase_detail t WHERE 1=1  "+condition)',
          outputParams: [
            { tableTitle: '物品编码', name: 'code' },
            { tableTitle: '物品名称', name: 'name' },
            { tableTitle: '规格型号', name: 'model' },
            { tableTitle: '单位', name: 'unit_name' },
            { tableTitle: '单价', name: 'price' },
            { tableTitle: '数量', name: 'count' },
            { tableTitle: '合计金额', name: 'total_price' },
            { tableTitle: '已入库', name: 'in_store_count' },
            { tableTitle: '未入库', name: 'no_in_store_count' },
            {},
            {},
          ],
        },
        itemId: '',
        dicOptions: [],
        useSelectButton: true,
        useAddButton: false, //不显示新增按钮
        buttonName: '新增',
        showLabel: true,
        showComponentBorder: true,
        showFormBorder: true,
        showIndex: false,
        multipleHeads: [],
      },
    },
    {
      key: 'aec03ef34d7e4e8bbcdd1975ec9235f3',
      field: '',
      label: '标题',
      type: 'title',
      component: 'Title',
      colProps: { span: 24 },
      ifShow: true,
      defaultValue: '附件',
      componentProps: { defaultValue: '附件', color: '', align: 'left', fontSize: 15, style: {} },
    },
    {
      key: 'f98cfb0cc54f4f4a87e7a01b58806162',
      field: 'outFile',
      label: '附件',
      type: 'upload',
      component: 'Upload',
      colProps: { span: 24 },
      componentProps: {
        api: uploadApi,
        span: '',
        defaultValue: [],
        accept: '',
        maxNumber: 5,
        maxSize: 5,
        showLabel: false,
        multiple: false,
        disabled: false,
        required: false,
        events: {},
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
