import {
  XjrPublishPageModel,
  XjrPublishPageParams,
  XjrPublishPageResult,
} from './model/PublishModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/version/publish/page',
  List = '/version/publish/list',
  Info = '/version/publish/info',
  XjrPublish = '/version/publish',
}

/**
 * @description: 查询XjrPublish分页列表
 */
export async function getXjrPublishPage(
  params: XjrPublishPageParams,
  mode: ErrorMessageMode = 'modal',
) {
  return defHttp.get<XjrPublishPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取XjrPublish信息
 */
export async function getXjrPublish(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<XjrPublishPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增XjrPublish
 */
export async function addXjrPublish(xjrPublish: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.XjrPublish,
      params: xjrPublish,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新XjrPublish
 */
export async function updateXjrPublish(xjrPublish: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.XjrPublish,
      params: xjrPublish,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除XjrPublish（批量删除）
 */
export async function deleteXjrPublish(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.XjrPublish,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}
