
import { MesBaseProductInfoPageModel, MesBaseProductInfoPageParams, MesBaseProductInfoPageResult } from './model/CpxxModel';
import { defHttp } from '/@/utils/http/axios';
import { ErrorMessageMode } from '/#/axios';

enum Api {
  Page = '/jcsj/cpxx/page',
  List = '/jcsj/cpxx/list',
  Info = '/jcsj/cpxx/info',
  MesBaseProductInfo = '/jcsj/cpxx',
  
  
  
}

/**
 * @description: 查询MesBaseProductInfo分页列表
 */
export async function getMesBaseProductInfoPage(params: MesBaseProductInfoPageParams, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseProductInfoPageResult>(
    {
      url: Api.Page,
      params,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 获取MesBaseProductInfo信息
 */
export async function getMesBaseProductInfo(id: String, mode: ErrorMessageMode = 'modal') {
  return defHttp.get<MesBaseProductInfoPageModel>(
    {
      url: Api.Info,
      params: { id },
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 新增MesBaseProductInfo
 */
export async function addMesBaseProductInfo(mesBaseProductInfo: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.post<boolean>(
    {
      url: Api.MesBaseProductInfo,
      params: mesBaseProductInfo,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 更新MesBaseProductInfo
 */
export async function updateMesBaseProductInfo(mesBaseProductInfo: Recordable, mode: ErrorMessageMode = 'modal') {
  return defHttp.put<boolean>(
    {
      url: Api.MesBaseProductInfo,
      params: mesBaseProductInfo,
    },
    {
      errorMessageMode: mode,
    },
  );
}

/**
 * @description: 删除MesBaseProductInfo（批量删除）
 */
export async function deleteMesBaseProductInfo(ids: string[], mode: ErrorMessageMode = 'modal') {
  return defHttp.delete<boolean>(
    {
      url: Api.MesBaseProductInfo,
      data: ids,
    },
    {
      errorMessageMode: mode,
    },
  );
}




