import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';
import { uploadApi } from '/@/api/sys/upload';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'versionNo',
    label: '版本号',
    component: 'Input',
  },
  {
    field: 'publishDate',
    label: '发版时间',
    component: 'RangePicker',
    componentProps: {
      format: 'YYYY-MM-DD HH:mm:ss',
      style: { width: '100%' },
      getPopupContainer: () => document.body,
    },
  },

  {
    field: 'publisher',
    label: '发版人',
    component: 'Input',
  },
  {
    field: 'publishStatus',
    label: '使用状态',
    component: 'Select',
    componentProps: {
      getPopupContainer: () => document.body,
      options: [
        {
          label: '开',
          value: 1,
        },
        {
          label: '关',
          value: 0,
        },
      ],
    },
  },

  {
    field: 'userArea',
    label: '发行范围',
    component: 'Input',
  },
  {
    field: 'publishRemark',
    label: '发版说明',
    component: 'Input',
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'versionNo',
    title: '版本号',
    componentType: 'input',

    // sorter: true,
    listStyle: '',
  },

  {
    dataIndex: 'publishDate',
    title: '发版时间',
    componentType: 'date',

    //sorter: true,
    listStyle: undefined,
  },

  {
    dataIndex: 'publisher',
    title: '发版人',
    componentType: 'input',

    // sorter: true,
    listStyle: '',
  },

  {
    dataIndex: 'publishStatus',
    title: '使用状态',
    componentType: 'switch',

    // sorter: true,
    listStyle: undefined,
  },

  {
    dataIndex: 'publishRemark',
    title: '发版说明',
    componentType: 'textarea',

    // sorter: true,
    listStyle: undefined,
  },

  {
    dataIndex: 'userArea',
    title: '发行范围',
    componentType: 'textarea',

    // sorter: true,
    listStyle: undefined,
  },
];
//表单事件
export const formEventConfigs = {
  0: [
    {
      type: 'circle',
      color: '#2774ff',
      text: '开始节点',
      icon: '#icon-kaishi',
      bgcColor: '#D8E5FF',
      isUserDefined: false,
    },
    {
      color: '#F6AB01',
      icon: '#icon-chushihua',
      text: '初始化表单',
      bgcColor: '#f9f5ea',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  1: [
    {
      color: '#B36EDB',
      icon: '#icon-shujufenxi',
      text: '获取表单数据',
      detail: '(新增无此操作)',
      bgcColor: '#F8F2FC',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  2: [
    {
      color: '#F8625C',
      icon: '#icon-jiazai',
      text: '加载表单',
      bgcColor: '#FFF1F1',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  3: [
    {
      color: '#6C6AE0',
      icon: '#icon-jsontijiao',
      text: '提交表单',
      bgcColor: '#F5F4FF',
      isUserDefined: false,
      nodeInfo: { processEvent: [] },
    },
  ],
  4: [
    {
      type: 'circle',
      color: '#F8625C',
      text: '结束节点',
      icon: '#icon-jieshuzhiliao',
      bgcColor: '#FFD6D6',
      isLast: true,
      isUserDefined: false,
    },
  ],
};
export const formProps: FormProps = {
  labelCol: { span: 3, offset: 0 },
  labelAlign: 'right',
  layout: 'vertical',
  size: 'default',
  schemas: [
    {
      key: '40d2b6d88c87475e93cd347ee6fd39f4',
      field: '',
      label: '',
      type: 'grid',
      colProps: { span: 24 },
      component: 'Grid',
      children: [
        {
          span: 12,
          list: [
            {
              key: '40eeae062cb5429691418047c912d277',
              field: 'versionNo',
              label: '版本号',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入版本号单行文本版本号',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                style: { width: '100%' },
              },
            },
            {
              key: 'f0ca29aa1ecd43058f5092b4cb6aef7e',
              field: 'initDb',
              label: '初始数据库',
              type: 'upload',
              component: 'Upload',
              colProps: { span: 24 },
              componentProps: {
                api: uploadApi,
                span: 7,
                defaultValue: [],
                accept: '',
                maxNumber: 5,
                maxSize: 10,
                showLabel: true,
                multiple: false,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                listType: 'text',
              },
            },
            {
              key: 'b029ecfe2ed34fb084af41b2b89cdc91',
              field: 'publishDate',
              label: '发版时间',
              type: 'date',
              component: 'DatePicker',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                span: 7,
                defaultValue: '',
                width: '100%',
                placeholder: '请选择发版时间',
                format: 'YYYY-MM-DD HH:mm:ss',
                showLabel: true,
                allowClear: true,
                disabled: false,
                required: false,
                isShow: true,
                rules: [],
                events: {},
                style: { width: '100%' },
              },
            },
          ],
        },
        {
          span: 12,
          list: [
            {
              key: '72f88745cd824308b7af60ea8ca367cd',
              field: 'publisher',
              label: '发版人',
              type: 'input',
              component: 'Input',
              colProps: { span: 24 },
              defaultValue: '',
              componentProps: {
                width: '100%',
                span: 7,
                defaultValue: '',
                placeholder: '请输入发版人',
                prefix: '',
                suffix: '',
                addonBefore: '',
                addonAfter: '',
                disabled: false,
                allowClear: false,
                showLabel: true,
                required: false,
                rules: [],
                events: {},
                listStyle: '',
                isSave: false,
                isShow: true,
                scan: false,
                style: { width: '100%' },
              },
            },
            {
              key: '653289d002f34b4e86c5fd5874908e03',
              field: 'buildFile',
              label: '程序文件',
              type: 'upload',
              component: 'Upload',
              colProps: { span: 24 },
              componentProps: {
                api: '#{upload}#',
                span: 7,
                defaultValue: [],
                accept: '',
                maxNumber: 5,
                maxSize: 20,
                showLabel: true,
                multiple: false,
                disabled: false,
                required: false,
                isShow: true,
                events: {},
                listType: 'text',
              },
            },
            {
              key: '1cd40f24ef894860863be92f3268098b',
              field: 'publishStatus',
              label: '使用状态',
              type: 'switch',
              component: 'Switch',
              colProps: { span: 24 },
              defaultValue: 1,
              componentProps: {
                span: 7,
                defaultValue: 1,
                checkedChildren: '',
                unCheckedChildren: '',
                checkedColor: '#5e95ff',
                unCheckedColor: '#bbbdbf',
                showLabel: true,
                disabled: false,
                events: {},
                isShow: true,
                style: {},
              },
            },
          ],
        },
      ],
      componentProps: { gutter: 16, justify: 'start', align: 'top', isShow: true },
    },
    {
      key: 'ac2c2bfb5e6949c8967ea8cfb5177e2f',
      field: 'userArea',
      label: '发行范围',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入发行范围',
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '841af67bb7e14e55812b58a97b4a9cf1',
      field: 'publishRemark',
      label: '发版说明',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        width: '100%',
        span: '',
        defaultValue: '',
        placeholder: '请输入发版说明',
        rows: 4,
        autoSize: false,
        showCount: false,
        disabled: false,
        showLabel: true,
        allowClear: false,
        required: false,
        isShow: true,
        rules: [],
        events: {},
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};

//左侧树结构配置
export const treeConfig = {
  id: '',
  isMultiple: false,
  name: '',
  type: 1,
  configTip: '',
  config: [],
};
