import { FormProps, FormSchema } from '/@/components/Form';
import { BasicColumn } from '/@/components/Table';

export const searchFormSchema: FormSchema[] = [
  {
    field: 'name',
    label: '项目名称',
    component: 'Input',
    colProps: { span: 8 },
  },
  {
    field: 'productType',
    label: '项目类型',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\nif(setup_type!=null&&setup_type!=""){ \r\n    condition+=" and setup_type=#{setup_type}";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_product_setup where state=1 "+condition)',
        apiParams: [
          {
            tableInfo: [
              {
                defaultValue: '1',
                bindType: 'value',
                required: false,
                name: 'setup_type',
                value: '1',
              },
            ],
            title: 'Query Params',
            key: '1',
          },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getProductSetupList',
        apiId: 'copy1690789010700d27388',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'productSource',
    label: '项目来源',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\nif(setup_type!=null&&setup_type!=""){ \r\n    condition+=" and setup_type=#{setup_type}";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_product_setup where state=1 "+condition)',
        apiParams: [
          {
            tableInfo: [
              {
                defaultValue: '1',
                bindType: 'value',
                required: false,
                name: 'setup_type',
                value: '4',
              },
            ],
            title: 'Query Params',
            key: '1',
          },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getProductSetupList',
        apiId: 'copy1690789010700d27388',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'productState',
    label: '项目状态',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\nif(setup_type!=null&&setup_type!=""){ \r\n    condition+=" and setup_type=#{setup_type}";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_product_setup where state=1 "+condition)',
        apiParams: [
          {
            tableInfo: [
              {
                defaultValue: '1',
                bindType: 'value',
                required: false,
                name: 'setup_type',
                value: '3',
              },
            ],
            title: 'Query Params',
            key: '1',
          },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getProductSetupList',
        apiId: 'copy1690789010700d27388',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
  {
    field: 'productStage',
    label: '项目阶段',
    component: 'XjrSelect',
    componentProps: {
      datasourceType: 'api',
      apiConfig: {
        method: 'GET',
        script:
          'var condition="";\r\nif(setup_type!=null&&setup_type!=""){ \r\n    condition+=" and setup_type=#{setup_type}";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_product_setup where state=1 "+condition)',
        apiParams: [
          {
            tableInfo: [
              {
                defaultValue: '1',
                bindType: 'value',
                required: false,
                name: 'setup_type',
                value: '2',
              },
            ],
            title: 'Query Params',
            key: '1',
          },
          { tableInfo: [], title: 'Header', key: '2' },
          { title: 'Body', key: '3' },
        ],
        path: '/mes/getProductSetupList',
        apiId: 'copy1690789010700d27388',
      },
      labelField: 'label',
      valueField: 'value',

      getPopupContainer: () => document.body,
    },
    colProps: { span: 8 },
  },
];

export const columns: BasicColumn[] = [
  {
    dataIndex: 'code',
    title: '项目编码',
    componentType: 'auto-code',
    sorter: true,
  },

  {
    dataIndex: 'name',
    title: '项目名称',
    componentType: 'input',

    sorter: true,
  },

  {
    dataIndex: 'productType',
    title: '项目类型',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'productSource',
    title: '项目来源',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'productState',
    title: '项目状态',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'productStage',
    title: '项目阶段',
    componentType: 'select',

    sorter: true,
  },

  {
    dataIndex: 'preCost',
    title: '预计费用(元)',
    componentType: 'number',

    sorter: true,
  },

  {
    dataIndex: 'totalCost',
    title: '项目总额',
    componentType: 'number',

    sorter: true,
  },

  {
    dataIndex: 'manageUser',
    title: '负责人',
    componentType: 'user',

    sorter: true,
  },

  {
    dataIndex: 'createUserId',
    title: '操作人',
    componentType: 'info',

    sorter: true,
  },

  {
    dataIndex: 'createDate',
    title: '操作时间',
    componentType: 'info',

    sorter: true,
  },
];

export const formProps: FormProps = {
  // labelCol: { offset: 0, span: 3 },
  labelWidth: '100px',
  labelAlign: 'right',
  layout: 'horizontal',
  size: 'default',
  schemas: [
    {
      key: '5d125c652d614690bb40426f5b1c2c73',
      field: 'code',
      label: '项目编码',
      type: 'auto-code',
      component: 'AutoCodeRule',
      colProps: { span: 8 },
      componentProps: {
        prefix: '',
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        placeholder: '请输入项目编码',
        addonBefore: '',
        autoCodeRule: 'mesproduct',
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'c4c67d80768c44dd9e90b3abc93f716f',
      field: 'isSysNum',
      label: '',
      type: 'checkbox',
      component: 'ApiCheckboxGroup',
      colProps: { span: 4 },
      componentProps: {
        defaultSelect: '1',
        rules: [],
        valueField: 'value',
        showLabel: false,
        required: false,
        labelField: 'label',
        datasourceType: 'staticData',
        dicOptions: [],
        apiConfig: {},
        disabled: false,
        staticOptions: [{ label: '用系统编码', value: '1', key: 1 }],
        events: {
          change:
            "if(formModel.isSysNum==1){\n\tformModel.code=formModel.code1; formActionType.updateSchema({field:'code'       ,componentProps: {readonly:true}});\n}else{\n  formModel.code1=formModel.code;\n  formModel.code='';\nformActionType.updateSchema({field:'code'       ,componentProps: {readonly:false}});\n}",
        },
        span: '',
        style: {},
      },
    },
    {
      key: 'aaf4473eaef14d18a004382f38632565',
      field: 'name',
      label: '项目名称',
      type: 'input',
      component: 'Input',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        prefix: '',
        rules: [],
        suffix: '',
        addonAfter: '',
        showLabel: true,
        required: true,
        width: '100%',
        disabled: false,
        placeholder: '请输入项目名称',
        allowClear: false,
        addonBefore: '',
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '686c51577d6d47aa87e85498999a3249',
      field: 'productType',
      label: '项目类型',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(setup_type!=null&&setup_type!=""){ \r\n    condition+=" and setup_type=#{setup_type}";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_product_setup where state=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                {
                  defaultValue: '1',
                  bindType: 'value',
                  required: false,
                  name: 'setup_type',
                  value: '1',
                },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getProductSetupList',
          apiId: 'copy1690789010700d27388',
        },
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '0d689f2e840e41e991ec06fc0aef0026',
      field: 'productSource',
      label: '项目来源',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(setup_type!=null&&setup_type!=""){ \r\n    condition+=" and setup_type=#{setup_type}";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_product_setup where state=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                {
                  defaultValue: '1',
                  bindType: 'value',
                  required: false,
                  name: 'setup_type',
                  value: '4',
                },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getProductSetupList',
          apiId: 'copy1690789010700d27388',
        },
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'ca13c1f51b1b408594efa563c3404224',
      field: 'productState',
      label: '项目状态',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(setup_type!=null&&setup_type!=""){ \r\n    condition+=" and setup_type=#{setup_type}";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_product_setup where state=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                {
                  defaultValue: '1',
                  bindType: 'value',
                  required: false,
                  name: 'setup_type',
                  value: '3',
                },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getProductSetupList',
          apiId: 'copy1690789010700d27388',
        },
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '38e752390075485aa457a10ae6fdfa1c',
      field: 'productStage',
      label: '项目阶段',
      type: 'select',
      component: 'XjrSelect',
      colProps: { span: 12 },
      componentProps: {
        clearable: false,
        defaultSelect: '',
        rules: [],
        valueField: 'value',
        showLabel: true,
        required: false,
        labelField: 'label',
        datasourceType: 'api',
        dicOptions: [],
        showSearch: false,
        width: '100%',
        apiConfig: {
          method: 'GET',
          script:
            'var condition="";\r\nif(setup_type!=null&&setup_type!=""){ \r\n    condition+=" and setup_type=#{setup_type}";\r\n}\r\n// if(warehouse_id!=null&&warehouse_id!=""){ \r\n//     condition+=" and warehouse_id=#{warehouse_id}";\r\n// }\r\n// if(area_id!=null&&area_id!=""){ \r\n//     condition+=" and area_id=#{area_id}";\r\n// }\r\n\r\nreturn db.select("SELECT id AS `key` ,id AS `value`,CONCAT(code,\'-\',name) AS label FROM mes_product_setup where state=1 "+condition)',
          apiParams: [
            {
              tableInfo: [
                {
                  defaultValue: '1',
                  bindType: 'value',
                  required: false,
                  name: 'setup_type',
                  value: '2',
                },
              ],
              title: 'Query Params',
              key: '1',
            },
            { tableInfo: [], title: 'Header', key: '2' },
            { title: 'Body', key: '3' },
          ],
          path: '/mes/getProductSetupList',
          apiId: 'copy1690789010700d27388',
        },
        disabled: false,
        placeholder: '请选择',
        staticOptions: [
          { label: 'Option 1', value: 'Option 1', key: 1 },
          { label: 'Option 2', value: 'Option 2', key: 2 },
          { label: 'Option 3', value: 'Option 3', key: 3 },
        ],
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '682e14c7edd24bf4a937b517fd3cdae6',
      field: 'preCost',
      label: '预计费用(元)',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 12 },
      defaultValue: 0,
      componentProps: {
        controls: true,
        //max: 100,
        defaultValue: 0,
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '3c8adb287769438295792efadb1e9343',
      field: 'totalCost',
      label: '项目总额',
      type: 'number',
      component: 'InputNumber',
      colProps: { span: 12 },
      defaultValue: 0,
      componentProps: {
        controls: true,
        //max: 100,
        defaultValue: 0,
        rules: [],
        subTotal: false,
        showLabel: true,
        required: false,
        min: 0,
        width: '100%',
        step: 1,
        disabled: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: '8bf62400eb3b4dfb9fc38c86b842edcb',
      field: 'manageUser',
      label: '负责人',
      type: 'user',
      component: 'User',
      colProps: { span: 12 },
      defaultValue: '',
      componentProps: {
        span: '',
        width: '100%',
        defaultValue: '',
        placeholder: '请选择人员',
        userType: 0,
        prefix: '',
        suffix: 'ant-design:setting-outlined',
        showLabel: true,
        disabled: false,
        required: false,
        events: {},
        style: { width: '100%' },
      },
    },
    {
      key: '30a2605654884e17ad181a9b5be5e71c',
      field: 'createUserId',
      label: '操作人',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        showLabel: true,
        infoType: 0,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'e628bfbca013402b82de377051eb4f97',
      field: 'createDate',
      label: '操作时间',
      type: 'info',
      component: 'Info',
      colProps: { span: 12 },
      ifShow: false,
      componentProps: {
        showLabel: true,
        infoType: 2,
        width: '100%',
        disabled: true,
        placeholder: '',
        loadAgain: false,
        span: '',
        style: { width: '100%' },
      },
    },
    {
      key: 'b3a821dab5524324b0ae06299d33c1f1',
      field: 'remark',
      label: '备注',
      type: 'textarea',
      component: 'InputTextArea',
      colProps: { span: 24 },
      defaultValue: '',
      componentProps: {
        defaultValue: '',
        rules: [],
        rows: 4,
        showLabel: true,
        required: false,
        autoSize: false,
        showCount: false,
        width: '100%',
        disabled: false,
        placeholder: '请输入',
        allowClear: false,
        events: {},
        span: '',
        style: { width: '100%' },
      },
    },
  ],
  showActionButtonGroup: false,
  buttonLocation: 'center',
  actionColOptions: { span: 24 },
  showResetButton: false,
  showSubmitButton: false,
  hiddenComponent: [],
};
